/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.AggGroupConcat;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import org.apache.jena.atlas.lib.Lib;

public class AggGroupConcatDistinct
extends AggregatorBase {
    private final String separator;
    private final String effectiveSeparator;

    public AggGroupConcatDistinct(Expr expr, String separator) {
        this(expr, separator != null ? separator : " ", separator);
    }

    private AggGroupConcatDistinct(Expr expr, String effectiveSeparator, String separatorSeen) {
        super("GROUP_CONCAT", true, expr);
        this.separator = separatorSeen;
        this.effectiveSeparator = effectiveSeparator;
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggGroupConcatDistinct(exprs.get(0), this.effectiveSeparator, this.separator);
    }

    @Override
    public String toPrefixString() {
        return AggGroupConcat.prefixGroupConcatString(this.isDistinct, this.separator, this.getExprList());
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        return AggGroupConcat.asSparqlExpr(this.isDistinct, this.separator, this.exprList, sCxt);
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccGroupConcatDistinct(this.getExpr(), this.effectiveSeparator);
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public Node getValueEmpty() {
        return null;
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.getExpr().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggGroupConcatDistinct)) {
            return false;
        }
        AggGroupConcatDistinct agg = (AggGroupConcatDistinct)other;
        return Lib.equal(agg.getSeparator(), this.getSeparator()) && agg.getExpr().equals(this.getExpr());
    }

    static class AccGroupConcatDistinct
    extends AccumulatorDistinctExpr {
        private StringBuilder stringSoFar = new StringBuilder();
        private boolean first = true;
        private final String separator;

        public AccGroupConcatDistinct(Expr expr, String sep) {
            super(expr);
            this.separator = sep;
        }

        @Override
        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            String str2 = nv.asString();
            if (!this.first) {
                this.stringSoFar.append(this.separator);
            }
            this.stringSoFar.append(str2);
            this.first = false;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeString(this.stringSoFar.toString());
        }
    }
}

