/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.cache;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cache;
import edu.uiuc.ncsa.security.core.cache.CachedObject;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;

public class MaxAgePolicy
implements RetentionPolicy<Identifier, CachedObject> {
    long maximumAge = 10000L;
    Cache map;

    public MaxAgePolicy(Cache cache, long maximumAge) {
        this.setMap(cache);
        this.setMaximumAge(maximumAge);
    }

    public long getMaximumAge() {
        return this.maximumAge;
    }

    public void setMaximumAge(long maximumAge) {
        this.maximumAge = maximumAge;
    }

    public void setMap(Cache map) {
        this.map = map;
    }

    public Cache getMap() {
        return this.map;
    }

    @Override
    public boolean retain(Identifier key, CachedObject cachedObject) {
        return this.timeOk(cachedObject.getTime());
    }

    boolean timeOk(long currentTime) {
        return System.currentTimeMillis() - currentTime <= this.getMaximumAge();
    }

    @Override
    public boolean applies() {
        if (this.getMap().isEmpty()) {
            return false;
        }
        CachedObject first = this.getMap().getSortedList().peek();
        return !this.timeOk(first.getTime());
    }
}

