/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@JsonIgnoreProperties(value={"metadataJSON", "idAsInt", "createdTimestamp"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Product {
    private Integer id;
    @NotEmpty
    @NotNull
    @Pattern(regexp="product")
    private @NotEmpty @NotNull @Pattern(regexp="product") String object;
    @NotNull
    private boolean active;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) Integer amount;
    @NotEmpty
    @NotNull
    @Length(max=500)
    private @NotEmpty @NotNull @Length(max=500) String caption;
    @NotEmpty
    @NotNull
    @Length(max=3)
    private @NotEmpty @NotNull @Length(max=3) String currency;
    private Integer created;
    @NotEmpty
    @NotNull
    @Length(max=1000)
    private @NotEmpty @NotNull @Length(max=1000) String description;
    @NotEmpty
    @NotNull
    @Pattern(regexp="day|week|month|year")
    private @NotEmpty @NotNull @Pattern(regexp="day|week|month|year") String interval;
    @NotEmpty
    @NotNull
    @Length(max=250)
    private @NotEmpty @NotNull @Length(max=250) String name;
    @Length(max=100)
    private @Length(max=100) String statementDescriptor;
    @NotEmpty
    @NotNull
    @Pattern(regexp="good|service")
    private @NotEmpty @NotNull @Pattern(regexp="good|service") String type;
    private String unitLabel;
    @Pattern(regexp="http.*")
    private @Pattern(regexp="http.*") String url;
    private ObjectNode metadata;

    public Product() {
    }

    public Product(Integer id, @NotEmpty @NotNull @Pattern(regexp="product") @NotEmpty @NotNull @Pattern(regexp="product") String object, @NotNull boolean active, @NotNull @Min(value=0L) @NotNull @Min(value=0L) Integer amount, @NotEmpty @NotNull @Length(max=500) @NotEmpty @NotNull @Length(max=500) String caption, @NotEmpty @NotNull @Length(max=3) @NotEmpty @NotNull @Length(max=3) String currency, Integer created, @NotEmpty @NotNull @Length(max=1000) @NotEmpty @NotNull @Length(max=1000) String description, @NotEmpty @NotNull @Pattern(regexp="day|week|month|year") @NotEmpty @NotNull @Pattern(regexp="day|week|month|year") String interval, @NotEmpty @NotNull @Length(max=250) @NotEmpty @NotNull @Length(max=250) String name, @Length(max=100) @Length(max=100) String statementDescriptor, @NotEmpty @NotNull @Pattern(regexp="good|service") @NotEmpty @NotNull @Pattern(regexp="good|service") String type, String unitLabel, @Pattern(regexp="http.*") @Pattern(regexp="http.*") String url, ObjectNode metadata) {
        this.id = id;
        this.object = object;
        this.active = active;
        this.amount = amount;
        this.caption = caption;
        this.currency = currency;
        this.created = created;
        this.description = description;
        this.interval = interval;
        this.name = name;
        this.statementDescriptor = statementDescriptor;
        this.type = type;
        this.unitLabel = unitLabel;
        this.url = url;
        this.metadata = metadata;
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    public int getIdAsInt() {
        return this.getId();
    }

    @JsonProperty
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty
    public String getObject() {
        return this.object;
    }

    @JsonProperty
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty
    public boolean isActive() {
        return this.active;
    }

    @JsonProperty
    public void setActive(boolean active) {
        this.active = active;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getCaption() {
        return this.caption;
    }

    @JsonProperty
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty
    public Integer getCreated() {
        return this.created;
    }

    @JsonProperty
    public void setCreated(Integer created) {
        this.created = created;
    }

    public String getCreatedTimestamp() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return formatter.format(new Date((long)this.getCreated().intValue() * 1000L));
    }

    @JsonProperty
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @JsonProperty
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty
    public String getUnitLabel() {
        return this.unitLabel;
    }

    @JsonProperty
    public void setUnitLabel(String unitLabel) {
        this.unitLabel = unitLabel;
    }

    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @JsonProperty
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty
    public ObjectNode getMetadata() {
        return this.metadata;
    }

    @JsonProperty
    public void setMetadata(ObjectNode metadata) {
        this.metadata = metadata;
    }

    public String getMetadataJSON() throws JsonProcessingException {
        if (this.metadata != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getMetadata());
        }
        return "{}";
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return this.isActive() == product.isActive() && Objects.equals(this.getId(), product.getId()) && Objects.equals(this.getObject(), product.getObject()) && Objects.equals(this.getAmount(), product.getAmount()) && Objects.equals(this.getCaption(), product.getCaption()) && Objects.equals(this.getCurrency(), product.getCurrency()) && Objects.equals(this.getCreated(), product.getCreated()) && Objects.equals(this.getDescription(), product.getDescription()) && Objects.equals(this.getInterval(), product.getInterval()) && Objects.equals(this.getName(), product.getName()) && Objects.equals(this.getStatementDescriptor(), product.getStatementDescriptor()) && Objects.equals(this.getType(), product.getType()) && Objects.equals(this.getUnitLabel(), product.getUnitLabel()) && Objects.equals(this.getUrl(), product.getUrl()) && Objects.equals(this.getMetadata(), product.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getObject(), this.isActive(), this.getAmount(), this.getCaption(), this.getCurrency(), this.getCreated(), this.getDescription(), this.getInterval(), this.getName(), this.getStatementDescriptor(), this.getType(), this.getUnitLabel(), this.getUrl(), this.getMetadata());
    }
}

