/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.dataone.bookkeeper.api.OrderItem;
import org.dataone.bookkeeper.api.Quota;

@JsonIgnoreProperties(value={"chargeJSON", "metadataJSON", "itemsJSON", "statusTransitionsJSON"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Order {
    private Integer id;
    @NotEmpty
    @NotNull
    @Pattern(regexp="order")
    private @NotEmpty @NotNull @Pattern(regexp="order") String object;
    private Integer amount;
    private Integer amountReturned;
    private ObjectNode charge;
    private Integer created;
    private String currency;
    private String subject;
    @NotNull
    private Integer customer;
    private String email;
    @NotEmpty
    @NotNull
    @Valid
    private List<OrderItem> items;
    private ObjectNode metadata;
    private String name;
    @Pattern(regexp="active|created|paid|past_due|refunded|trialing|unpaid")
    private @Pattern(regexp="active|created|paid|past_due|refunded|trialing|unpaid") String status;
    private ObjectNode statusTransitions;
    private Integer updated;
    private String seriesId;
    private Integer startDate;
    private Integer endDate;
    private List<Quota> quotas;

    public Order() {
    }

    public Order(Integer id, @NotEmpty @NotNull @Pattern(regexp="order") @NotEmpty @NotNull @Pattern(regexp="order") String object, @NotNull Integer amount, Integer amountReturned, ObjectNode charge, Integer created, String currency, String subject, @NotNull Integer customer, String email, @NotEmpty @NotNull @Valid List<OrderItem> items, ObjectNode metadata, String name, @NotEmpty @NotNull @Pattern(regexp="active|created|paid|past_due|refunded|trialing|unpaid") @NotEmpty @NotNull @Pattern(regexp="active|created|paid|past_due|refunded|trialing|unpaid") String status, ObjectNode statusTransitions, Integer updated, String seriesId, Integer startDate, Integer endDate, List<Quota> quotas) {
        this.id = id;
        this.object = object;
        this.amount = amount;
        this.amountReturned = amountReturned;
        this.charge = charge;
        this.created = created;
        this.currency = currency;
        this.subject = subject;
        this.customer = customer;
        this.email = email;
        this.items = items;
        this.metadata = metadata;
        this.name = name;
        this.status = status;
        this.statusTransitions = statusTransitions;
        this.updated = updated;
        this.seriesId = seriesId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.quotas = quotas;
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    @JsonProperty
    public void setId(Integer id) {
        this.id = id;
    }

    @JsonProperty
    public String getObject() {
        return this.object;
    }

    @JsonProperty
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    @JsonProperty
    public Integer getTotalAmount() {
        Integer total = 0;
        if (!this.getItems().isEmpty()) {
            for (OrderItem item : this.getItems()) {
                total = total + item.getAmount();
            }
        }
        return total;
    }

    @JsonProperty
    public Integer getAmountReturned() {
        return this.amountReturned;
    }

    @JsonProperty
    public void setAmountReturned(Integer amountReturned) {
        this.amountReturned = amountReturned;
    }

    @JsonProperty
    public ObjectNode getCharge() {
        return this.charge;
    }

    @JsonProperty
    public void setCharge(ObjectNode charge) {
        this.charge = charge;
    }

    @JsonProperty
    public Integer getCreated() {
        return this.created;
    }

    @JsonProperty
    public void setCreated(Integer created) {
        this.created = created;
    }

    @JsonProperty
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @JsonProperty
    public Integer getCustomer() {
        return this.customer;
    }

    @JsonProperty
    public void setCustomer(Integer customer) {
        this.customer = customer;
    }

    @JsonProperty
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty
    public String getEmail() {
        return this.email;
    }

    @JsonProperty
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty
    public List<OrderItem> getItems() {
        return this.items;
    }

    @JsonProperty
    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    @JsonProperty
    public ObjectNode getMetadata() {
        return this.metadata;
    }

    @JsonProperty
    public void setMetadata(ObjectNode metadata) {
        this.metadata = metadata;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getStatus() {
        return this.status;
    }

    @JsonProperty
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty
    public ObjectNode getStatusTransitions() {
        return this.statusTransitions;
    }

    @JsonProperty
    public void setStatusTransitions(ObjectNode statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @JsonProperty
    public Integer getUpdated() {
        return this.updated;
    }

    @JsonProperty
    public void setUpdated(Integer updated) {
        this.updated = updated;
    }

    @JsonProperty
    public String getSeriesId() {
        return this.seriesId;
    }

    @JsonProperty
    public void setSeriesId(String seriesId) {
        this.seriesId = seriesId;
    }

    @JsonProperty
    public Integer getStartDate() {
        return this.startDate;
    }

    @JsonProperty
    public void setStartDate(Integer startDate) {
        this.startDate = startDate;
    }

    @JsonProperty
    public Integer getEndDate() {
        return this.endDate;
    }

    @JsonProperty
    public void setEndDate(Integer endDate) {
        this.endDate = endDate;
    }

    @JsonProperty
    public List<Quota> getQuotas() {
        return this.quotas;
    }

    @JsonProperty
    public void setQuotas(List<Quota> quotas) {
        this.quotas = quotas;
    }

    public String getChargeJSON() throws JsonProcessingException {
        if (this.charge != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getCharge());
        }
        return "{}";
    }

    public String getItemsJSON() throws IOException {
        if (this.items != null) {
            ObjectMapper mapper = new ObjectMapper();
            ArrayNode itemsArray = mapper.createArrayNode();
            for (OrderItem item : this.items) {
                itemsArray.add(mapper.readTree(mapper.writeValueAsString((Object)item)));
            }
            return itemsArray.toString();
        }
        return "[]";
    }

    public String getMetadataJSON() throws JsonProcessingException {
        if (this.metadata != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getMetadata());
        }
        return "{}";
    }

    public String getStatusTransitionsJSON() throws JsonProcessingException {
        if (this.statusTransitions != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getStatusTransitions());
        }
        return "{}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return Objects.equals(this.getId(), order.getId()) && this.getObject().equals(order.getObject()) && this.getAmount().equals(order.getAmount()) && Objects.equals(this.getAmountReturned(), order.getAmountReturned()) && Objects.equals(this.getCharge(), order.getCharge()) && Objects.equals(this.getCreated(), order.getCreated()) && Objects.equals(this.getCurrency(), order.getCurrency()) && Objects.equals(this.getSubject(), order.getSubject()) && this.getCustomer().equals(order.getCustomer()) && Objects.equals(this.getEmail(), order.getEmail()) && this.getItems().equals(order.getItems()) && Objects.equals(this.getMetadata(), order.getMetadata()) && Objects.equals(this.getName(), order.getName()) && this.getStatus().equals(order.getStatus()) && Objects.equals(this.getStatusTransitions(), order.getStatusTransitions()) && Objects.equals(this.getUpdated(), order.getUpdated()) && this.getSeriesId().equals(order.getSeriesId()) && Objects.equals(this.getStartDate(), order.getStartDate()) && Objects.equals(this.getEndDate(), order.getEndDate()) && Objects.equals(this.getQuotas(), order.getQuotas());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getObject(), this.getAmount(), this.getAmountReturned(), this.getCharge(), this.getCreated(), this.getCurrency(), this.getSubject(), this.getCustomer(), this.getEmail(), this.getItems(), this.getMetadata(), this.getName(), this.getStatus(), this.getStatusTransitions(), this.getUpdated(), this.getSeriesId(), this.getStartDate(), this.getEndDate(), this.getQuotas());
    }
}

