/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.matcher;

import org.dataone.annotator.matcher.ConceptMatcher;
import org.dataone.annotator.matcher.bioportal.BioPortalService;
import org.dataone.annotator.matcher.esor.EsorService;
import org.dataone.annotator.matcher.orcid.OrcidService;

public class ConceptMatcherFactory {
    public static final int BIOPORTAL = 1;
    public static final int ESOR = 2;
    public static final int ORCID = 3;

    public static ConceptMatcher getMatcher(int type) {
        ConceptMatcher matcher = null;
        switch (type) {
            case 1: {
                matcher = new BioPortalService();
                break;
            }
            case 2: {
                matcher = new EsorService();
                break;
            }
            case 3: {
                matcher = new OrcidService();
                break;
            }
        }
        return matcher;
    }

    public static ConceptMatcher getMatcher(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ConceptMatcher matcher = (ConceptMatcher)Class.forName(className).newInstance();
        return matcher;
    }
}

