/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.annotator.store.JsonAnnotatorStore;
import org.dataone.client.auth.CertificateManager;
import org.dataone.portal.PortalCertificateManager;
import org.dataone.portal.TokenGenerator;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SubjectInfo;

public class AnnotatorRestServlet
extends HttpServlet {
    public static Log log = LogFactory.getLog(AnnotatorRestServlet.class);

    public static Session getSession(HttpServletRequest request) throws BaseException {
        log.debug((Object)"Inspecting request for session information");
        Session session = null;
        if (session == null) {
            AnnotatorRestServlet.debugHeaders(request);
            String token = request.getHeader("x-annotator-auth-token");
            try {
                session = TokenGenerator.getInstance().getSession(token);
            }
            catch (IOException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            log.warn((Object)("Session from x-annotator-auth-token: " + session));
        }
        if (session == null) {
            try {
                session = PortalCertificateManager.getInstance().getSession(request);
                log.warn((Object)("Session from original request: " + session));
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return session;
    }

    private static void debugHeaders(HttpServletRequest request) {
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String name = (String)headers.nextElement();
            String value = request.getHeader(name);
            log.debug((Object)("Header: " + name + "=" + value));
        }
    }

    private String getResource(HttpServletRequest request) {
        String resource = request.getPathInfo();
        resource = resource.substring(resource.indexOf("/") + 1);
        return resource;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"HTTP Verb: GET");
        String resource = this.getResource(request);
        JsonAnnotatorStore as = null;
        try {
            as = new JsonAnnotatorStore(AnnotatorRestServlet.getSession(request));
        }
        catch (BaseException e) {
            throw new ServletException((Throwable)e);
        }
        if (resource.startsWith("annotations/")) {
            String id = request.getPathInfo().substring(request.getPathInfo().lastIndexOf("/") + 1);
            try {
                String result = as.read(id);
                IOUtils.write((String)result, (OutputStream)response.getOutputStream());
                return;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (resource.startsWith("annotations")) {
            try {
                String result = as.index();
                IOUtils.write((String)result, (OutputStream)response.getOutputStream());
                return;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (resource.startsWith("search")) {
            String query = request.getQueryString();
            try {
                String result = as.search(query);
                IOUtils.write((String)result, (OutputStream)response.getOutputStream());
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServletException((Throwable)e);
            }
        }
        if (resource.startsWith("token")) {
            String token = "";
            try {
                X509Certificate certificate = PortalCertificateManager.getInstance().getCertificate(request);
                if (certificate != null) {
                    String userId = CertificateManager.getInstance().getSubjectDN(certificate);
                    String fullName = null;
                    SubjectInfo subjectInfo = CertificateManager.getInstance().getSubjectInfo(certificate);
                    if (subjectInfo != null) {
                        fullName = subjectInfo.getPerson(0).getFamilyName();
                        if (subjectInfo.getPerson(0).getGivenNameList() != null && subjectInfo.getPerson(0).getGivenNameList().size() > 0) {
                            fullName = subjectInfo.getPerson(0).getGivenName(0) + fullName;
                        }
                    }
                    token = TokenGenerator.getInstance().getJWT(userId, fullName);
                    Cookie cookie = PortalCertificateManager.getInstance().getCookie(request);
                    String identifier = cookie.getValue();
                    PortalCertificateManager.getInstance().setCookie(identifier, response);
                }
                response.getWriter().print(token);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"HTTP Verb: POST");
        JsonAnnotatorStore as = null;
        try {
            as = new JsonAnnotatorStore(AnnotatorRestServlet.getSession(request));
        }
        catch (BaseException e) {
            throw new ServletException((Throwable)e);
        }
        String resource = this.getResource(request);
        if (resource.equals("annotations")) {
            try {
                ServletInputStream is = request.getInputStream();
                String annotationContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
                String id = as.create(annotationContent);
                boolean redirect = false;
                if (redirect) {
                    response.setStatus(303);
                    response.sendRedirect(request.getRequestURI() + "/" + id);
                } else {
                    response.setStatus(200);
                    annotationContent = as.read(id);
                    IOUtils.write((String)annotationContent, (OutputStream)response.getOutputStream());
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"HTTP Verb: DELETE");
        JsonAnnotatorStore as = null;
        try {
            as = new JsonAnnotatorStore(AnnotatorRestServlet.getSession(request));
        }
        catch (BaseException e) {
            throw new ServletException((Throwable)e);
        }
        String resource = this.getResource(request);
        if (resource.startsWith("annotations/")) {
            String id = request.getPathInfo().substring(request.getPathInfo().lastIndexOf("/") + 1);
            try {
                as.delete(id);
                response.setContentLength(0);
                response.setStatus(204);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"HTTP Verb: PUT");
        JsonAnnotatorStore as = null;
        try {
            as = new JsonAnnotatorStore(AnnotatorRestServlet.getSession(request));
        }
        catch (BaseException e) {
            throw new ServletException((Throwable)e);
        }
        String resource = this.getResource(request);
        if (resource.startsWith("annotations/")) {
            try {
                String id = request.getPathInfo().substring(request.getPathInfo().lastIndexOf("/") + 1);
                ServletInputStream is = request.getInputStream();
                String result = as.update(id, IOUtils.toString((InputStream)is, (String)"UTF-8"));
                boolean redirect = false;
                if (redirect) {
                    response.setStatus(303);
                    response.sendRedirect(request.getRequestURI() + "/" + id);
                } else {
                    response.setStatus(200);
                    IOUtils.write((String)result, (OutputStream)response.getOutputStream());
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"HTTP Verb: HEAD");
    }
}

