/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.db.impl.DBQueryHandler;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.mem.GraphMemBaseQueryHandler;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterBlockTriples;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterBlockTriplesQH;
import com.hp.hpl.jena.sparql.engine.main.Stage;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Utils;

public class StageBasic
implements Stage {
    public static Symbol altMatcher = ARQConstants.allocSymbol("altmatcher");
    protected BasicPattern pattern;

    public StageBasic(BasicPattern pattern) {
        this.pattern = pattern;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        if (input == null) {
            ALog.fatal(this, "Null input to " + Utils.classShortName(this.getClass()));
        }
        QueryIterator cIter = StageBasic.createMatcher(input, this.pattern, execCxt);
        return cIter;
    }

    private static QueryIterator createMatcher(QueryIterator input, BasicPattern pattern, ExecutionContext cxt) {
        QueryHandler qh = cxt.getActiveGraph().queryHandler();
        if (qh instanceof DBQueryHandler) {
            return QueryIterBlockTriplesQH.create(input, pattern, cxt);
        }
        if (qh instanceof GraphMemBaseQueryHandler && cxt.getContext().isTrueOrUndef(altMatcher)) {
            return QueryIterBlockTriples.create(input, pattern, cxt);
        }
        return QueryIterBlockTriplesQH.create(input, pattern, cxt);
    }
}

