/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.main.Stage;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.main.StageList;
import com.hp.hpl.jena.sparql.engine.main.StagePropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.GNode;
import com.hp.hpl.jena.sparql.util.GraphList;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class StageGenPropertyFunctionX
implements StageGenerator {
    private StageGenerator other;

    private StageGenPropertyFunctionX(StageGenerator other) {
        this.other = other;
    }

    public StageList compile(BasicPattern pattern, ExecutionContext execCxt) {
        if (pattern.isEmpty()) {
            return new StageList();
        }
        boolean doingMagicProperties = execCxt.getContext().isTrue(ARQ.enablePropertyFunctions);
        if (!doingMagicProperties) {
            return this.other.compile(pattern, execCxt);
        }
        return StageGenPropertyFunctionX.process(pattern, this.other, execCxt);
    }

    private static StageList process(BasicPattern pattern, StageGenerator other, ExecutionContext execCxt) {
        Context context = execCxt.getContext();
        PropertyFunctionRegistry registry = StageGenPropertyFunctionX.chooseRegistry(context);
        ArrayList propertyFunctionTriples = new ArrayList();
        BasicPattern triples = new BasicPattern();
        StageGenPropertyFunctionX.findPropetryFunctions(context, pattern, registry, triples, propertyFunctionTriples);
        HashMap pfStages = new HashMap();
        StageGenPropertyFunctionX.makePropetryFunctions(context, registry, pfStages, triples, propertyFunctionTriples);
        StageList stages = new StageList();
        StageGenPropertyFunctionX.makeStages(context, other, stages, pfStages, triples, propertyFunctionTriples, execCxt);
        return stages;
    }

    private static void findPropetryFunctions(Context context, BasicPattern pattern, PropertyFunctionRegistry registry, BasicPattern triples, List propertyFunctionTriples) {
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Triple)) {
                ALog.warn(StageGenPropertyFunctionX.class, "Don't recognize: [" + Utils.className(obj) + "]");
                throw new ARQInternalErrorException("Not a triple pattern: " + obj.toString());
            }
            Triple t = (Triple)obj;
            triples.add(t);
            if (!StageGenPropertyFunctionX.isMagicProperty(registry, t)) continue;
            propertyFunctionTriples.add(t);
        }
    }

    private static void makePropetryFunctions(Context context, PropertyFunctionRegistry registry, Map pfStages, BasicPattern triples, List propertyFunctionTriples) {
        Iterator iter = propertyFunctionTriples.iterator();
        while (iter.hasNext()) {
            Triple pf = (Triple)iter.next();
            Stage stage = StageGenPropertyFunctionX.magicProperty(context, registry, pf, triples);
            if (stage == null) {
                ALog.warn(class$com$hp$hpl$jena$sparql$engine$main$StageGenPropertyFunctionX == null ? StageGenPropertyFunctionX.class$("com.hp.hpl.jena.sparql.engine.main.StageGenPropertyFunctionX") : class$com$hp$hpl$jena$sparql$engine$main$StageGenPropertyFunctionX, "Lost a Stage for a property function");
                continue;
            }
            pfStages.put(pf, stage);
        }
    }

    private static void makeStages(Context context, StageGenerator other, StageList stages, Map pfStages, BasicPattern triples, List propertyFunctionTriples, ExecutionContext execCxt) {
        BasicPattern pattern = null;
        ListIterator iter = triples.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (propertyFunctionTriples.contains(t)) {
                StageGenPropertyFunctionX.flush(pattern, stages, other, execCxt);
                pattern = null;
                Stage stage = (Stage)pfStages.get(t);
                stages.add(stage);
                continue;
            }
            if (pattern == null) {
                pattern = new BasicPattern();
            }
            pattern.add(t);
        }
        StageGenPropertyFunctionX.flush(pattern, stages, other, execCxt);
    }

    private static void flush(BasicPattern pattern, StageList stages, StageGenerator other, ExecutionContext execCxt) {
        if (pattern == null || pattern.isEmpty()) {
            return;
        }
        StageList sl = other.compile(pattern, execCxt);
        stages.addAll(sl);
    }

    private static PropertyFunctionRegistry chooseRegistry(Context context) {
        PropertyFunctionRegistry registry = PropertyFunctionRegistry.get(context);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }

    private static boolean isMagicProperty(PropertyFunctionRegistry registry, Triple pfTriple) {
        if (!pfTriple.getPredicate().isURI()) {
            return false;
        }
        return registry.manages(pfTriple.getPredicate().getURI());
    }

    private static Stage magicProperty(Context context, PropertyFunctionRegistry registry, Triple pfTriple, BasicPattern triples) {
        if (!StageGenPropertyFunctionX.isMagicProperty(registry, pfTriple)) {
            throw new ARQInternalErrorException("Not a property function: " + pfTriple.getMatchPredicate());
        }
        ArrayList listTriples = new ArrayList();
        GNode sGNode = new GNode(triples, pfTriple.getSubject());
        GNode oGNode = new GNode(triples, pfTriple.getObject());
        List sList = null;
        List oList = null;
        if (GraphList.isListNode(sGNode)) {
            sList = GraphList.members(sGNode);
            GraphList.allTriples(sGNode, listTriples);
        }
        if (GraphList.isListNode(oGNode)) {
            oList = GraphList.members(oGNode);
            GraphList.allTriples(oGNode, listTriples);
        }
        PropFuncArg subjArgs = new PropFuncArg(sList, pfTriple.getSubject());
        PropFuncArg objArgs = new PropFuncArg(oList, pfTriple.getObject());
        StagePropertyFunction propFuncStage = StagePropertyFunction.make(context, subjArgs, pfTriple.getPredicate(), objArgs);
        if (propFuncStage != null) {
            triples.getList().removeAll(listTriples);
        }
        return propFuncStage;
    }
}

