/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Probability;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Selectivity;

public abstract class ProbabilityBase
implements Probability {
    protected double minProbability = 0.0;
    protected long dataGraphSize = 0L;
    protected long squaredDataGraphSize = 0L;
    protected Model dataModel = null;
    protected Model indexModel = null;
    protected Selectivity selectivity = null;
    protected Graph dataGraph = null;
    protected boolean isLoaded = false;
    protected GraphStatisticsHandler graphStatisticsHandler = null;

    public void create(Model dataModel) {
        if (dataModel == null) {
            return;
        }
        this.dataModel = dataModel;
        this.dataGraph = dataModel.getGraph();
        this.dataGraphSize = this.getSize(dataModel);
        this.squaredDataGraphSize = this.dataGraphSize * this.dataGraphSize;
        this.graphStatisticsHandler = this.dataGraph.getStatisticsHandler();
        this.selectivity = new Selectivity(dataModel);
    }

    public void load(Model dataModel) {
        if (dataModel == null) {
            return;
        }
        this.dataModel = dataModel;
        this.dataGraph = dataModel.getGraph();
        this.dataGraphSize = this.dataGraph.size();
        this.squaredDataGraphSize = this.dataGraphSize * this.dataGraphSize;
        this.graphStatisticsHandler = this.dataGraph.getStatisticsHandler();
        this.selectivity = new Selectivity(dataModel);
    }

    public abstract double getProbability(Triple var1);

    public abstract double getSelectivity(Triple var1);

    public abstract double getProbability(Triple var1, Triple var2);

    public abstract double getSelectivity(Triple var1, Triple var2);

    public double getProbability(Property property) {
        return this.getProbability(new Triple(Node.ANY, property.asNode(), Node.ANY));
    }

    public double getSelectivity(Property property) {
        return this.getSelectivity(new Triple(Node.ANY, property.asNode(), Node.ANY));
    }

    public double getProbability(Resource resource) {
        return this.getProbability(new Triple(resource.asNode(), Node.ANY, Node.ANY));
    }

    public double getSelectivity(Resource resource) {
        return this.getSelectivity(new Triple(resource.asNode(), Node.ANY, Node.ANY));
    }

    public double getMinProbability() {
        return this.minProbability;
    }

    public long getDataGraphSize() {
        return this.dataGraphSize;
    }

    public long getSquaredDataGraphSize() {
        return this.squaredDataGraphSize;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    protected double getProbability(double sp, double pp, double op) {
        return sp * pp * op;
    }

    protected double check(double p) {
        if (p < this.minProbability) {
            return this.minProbability;
        }
        return p;
    }

    private long getSize(Model model) {
        long size = 0L;
        StmtIterator stmtIter = model.listStatements();
        while (stmtIter.hasNext()) {
            stmtIter.next();
            ++size;
        }
        stmtIter.close();
        return size;
    }
}

