/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.modify.UpdateVisitor;
import com.hp.hpl.jena.sparql.modify.op.UpdateClear;
import com.hp.hpl.jena.sparql.modify.op.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.op.UpdateDelete;
import com.hp.hpl.jena.sparql.modify.op.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.op.UpdateInsert;
import com.hp.hpl.jena.sparql.modify.op.UpdateLoad;
import com.hp.hpl.jena.sparql.modify.op.UpdateModify;
import com.hp.hpl.jena.sparql.modify.op.UpdateModifyBase;
import com.hp.hpl.jena.sparql.serializer.FmtTemplateARQ;
import com.hp.hpl.jena.sparql.serializer.FormatterARQ;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.util.Iterator;

public class UpdateSerializer
implements UpdateVisitor {
    IndentedWriter out;
    SerializationContext sCxt;

    public UpdateSerializer(IndentedWriter out, SerializationContext sCxt) {
        this.out = out;
        this.sCxt = sCxt;
    }

    private void visitModifyHeader(String name, String word, UpdateModifyBase modify) {
        this.out.print(name);
        Iterator iter = modify.getGraphNames().iterator();
        while (iter.hasNext()) {
            String iri = (String)iter.next();
            if (word != null) {
                this.out.print(" ");
                this.out.print(word);
            }
            this.out.print(" ");
            this.out.print(FmtUtils.stringForURI(iri, this.sCxt));
        }
        this.out.println();
    }

    private void visitModifyTrailer(UpdateModifyBase modify) {
        if (modify.getElement() != null) {
            this.out.println("WHERE");
            this.out.incIndent();
            FormatterARQ.format(this.out, this.sCxt, modify.getElement());
            this.out.decIndent();
            this.out.println();
        }
    }

    public void visit(UpdateModify modify) {
        this.visitModifyHeader("MODIFY", "GRAPH", modify);
        this.out.println("DELETE");
        this.printTemplate(modify.getDeleteTemplate());
        this.out.println("INSERT");
        this.printTemplate(modify.getInsertTemplate());
        this.visitModifyTrailer(modify);
    }

    public void visit(UpdateDelete delete) {
        this.visitModifyHeader("DELETE", "FROM", delete);
        this.printTemplate(delete.getDeleteTemplate());
        this.visitModifyTrailer(delete);
    }

    public void visit(UpdateInsert insert) {
        this.visitModifyHeader("INSERT", "INTO", insert);
        this.printTemplate(insert.getInsertTemplate());
        this.visitModifyTrailer(insert);
    }

    public void visit(UpdateClear clear) {
        this.out.print("CLEAR");
        if (clear.hasGraphName()) {
            this.out.print(" ");
            FmtUtils.stringForNode(clear.getGraphName(), this.sCxt);
        }
        this.out.println();
    }

    public void visit(UpdateLoad load) {
        this.out.print("LOAD");
        Iterator iter = load.getLoadIRIs().iterator();
        while (iter.hasNext()) {
            String iri = (String)iter.next();
            this.out.print(" ");
            FmtUtils.stringForURI(iri, this.sCxt);
        }
        if (load.hasGraphName()) {
            this.out.print(" ");
            this.out.print("INTO");
            this.out.print(" ");
            String s = FmtUtils.stringForNode(load.getGraphName(), this.sCxt);
            this.out.print(s);
        }
        this.out.println();
    }

    public void visit(UpdateDrop drop) {
        this.out.print("DROP");
        if (drop.isSilent()) {
            this.out.print(" ");
            this.out.print("SILENT");
        }
        this.out.print(" ");
        this.out.print("GRAPH");
        this.out.print(" ");
        this.out.print(FmtUtils.stringForNode(drop.getIRI(), this.sCxt));
        this.out.println();
    }

    public void visit(UpdateCreate create) {
        this.out.print("CREATE");
        if (create.isSilent()) {
            this.out.print(" ");
            this.out.print("SILENT");
        }
        this.out.print(" ");
        this.out.print("GRAPH");
        this.out.print(" ");
        this.out.print(FmtUtils.stringForNode(create.getIRI(), this.sCxt));
        this.out.println();
    }

    private void printTemplate(Template template) {
        this.out.incIndent();
        FmtTemplateARQ.format(this.out, this.sCxt, template);
        this.out.decIndent();
    }
}

