/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TS_Functions
extends TestCase {
    static final String testSetName = "Functions";
    private static final NodeValue INT_ZERO = NodeValue.makeInteger(0L);
    private static final NodeValue INT_ONE = NodeValue.makeInteger(1L);
    private static final NodeValue INT_TWO = NodeValue.makeInteger(2L);
    private static final NodeValue TRUE = NodeValue.TRUE;
    private static final NodeValue FALSE = NodeValue.FALSE;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TS_Functions.class);
        ts.setName(testSetName);
        return ts;
    }

    public void test1() {
        this.test("1", NodeValue.makeInteger(1L));
    }

    public void testStrLen1() {
        this.test("fn:string-length('')", INT_ZERO);
    }

    public void testStrLen2() {
        this.test("fn:string-length('a')", INT_ONE);
    }

    public void testSubstring1() {
        this.test("fn:substring('',0)", NodeValue.makeString(""));
    }

    public void testSubstring2() {
        this.test("fn:substring('',1)", NodeValue.makeString(""));
    }

    public void testSubstring3() {
        this.test("fn:substring('',1,0)", NodeValue.makeString(""));
    }

    public void testSubstring4() {
        this.test("fn:substring('',1,1)", NodeValue.makeString(""));
    }

    public void testSubstring5() {
        this.test("fn:substring('abc',1)", NodeValue.makeString("abc"));
    }

    public void testSubstring6() {
        this.test("fn:substring('abc',2)", NodeValue.makeString("bc"));
    }

    public void testSubstring7() {
        this.test("fn:substring('a',1,1)", NodeValue.makeString("a"));
    }

    public void testSubstring8() {
        this.test("fn:substring('a',1,2)", NodeValue.makeString("a"));
    }

    public void testSubstring9() {
        this.test("fn:substring('a',0)", NodeValue.makeString("a"));
    }

    public void testSubstring10() {
        this.test("fn:substring('abc',1.6,1.33)", NodeValue.makeString("b"));
    }

    public void testSubstring11() {
        this.test("fn:substring('abc',-1, -15.3)", NodeValue.makeString(""));
    }

    public void testJavaSubstring1() {
        this.test("afn:substr('abc',0,0)", NodeValue.makeString(""));
    }

    public void testJavaSubstring2() {
        this.test("afn:substr('abc',0,1)", NodeValue.makeString("a"));
    }

    public void testJavaSubstring3() {
        this.test("<java:com.hp.hpl.jena.sparql.function.library.substr>('abc',0,0)", NodeValue.makeString(""));
    }

    public void testJavaSubstring4() {
        this.test("<java:com.hp.hpl.jena.sparql.function.library.substr>('abc',0,1)", NodeValue.makeString("a"));
    }

    public void testStrStart0() {
        this.test("fn:starts-with('abc', '')", TRUE);
    }

    public void testStrStart1() {
        this.test("fn:starts-with('abc', 'a')", TRUE);
    }

    public void testStrStart2() {
        this.test("fn:starts-with('abc', 'ab')", TRUE);
    }

    public void testStrStart3() {
        this.test("fn:starts-with('abc', 'abc')", TRUE);
    }

    public void testStrStart4() {
        this.test("fn:starts-with('abc', 'abcd')", FALSE);
    }

    public void testStrEnds0() {
        this.test("fn:ends-with('abc', '')", TRUE);
    }

    public void testStrEnds1() {
        this.test("fn:ends-with('abc', 'c')", TRUE);
    }

    public void testStrEnds2() {
        this.test("fn:ends-with('abc', 'bc')", TRUE);
    }

    public void testStrEnds3() {
        this.test("fn:ends-with('abc', 'abc')", TRUE);
    }

    public void testStrEnds4() {
        this.test("fn:ends-with('abc', 'zabc')", FALSE);
    }

    public void testStrCase1() {
        this.test("fn:lower-case('aBc')", NodeValue.makeString("abc"));
    }

    public void testStrCase2() {
        this.test("fn:lower-case('abc')", NodeValue.makeString("abc"));
    }

    public void testStrCase3() {
        this.test("fn:upper-case('abc')", NodeValue.makeString("ABC"));
    }

    public void testStrCase4() {
        this.test("fn:upper-case('ABC')", NodeValue.makeString("ABC"));
    }

    public void testStrContains0() {
        this.test("fn:contains('abc', '')", TRUE);
    }

    public void testStrContains1() {
        this.test("fn:contains('abc', 'a')", TRUE);
    }

    public void testStrContains2() {
        this.test("fn:contains('abc', 'b')", TRUE);
    }

    public void testStrContains3() {
        this.test("fn:contains('abc', 'c')", TRUE);
    }

    public void testStrContains4() {
        this.test("fn:contains('abc', 'ab')", TRUE);
    }

    public void testStrContains5() {
        this.test("fn:contains('abc', 'bc')", TRUE);
    }

    public void testStrContains6() {
        this.test("fn:contains('abc', 'abc')", TRUE);
    }

    public void testStrContains7() {
        this.test("fn:contains('abc', 'Xc')", FALSE);
    }

    public void testStrContains8() {
        this.test("fn:contains('abc', 'Xa')", FALSE);
    }

    public void testBoolean1() {
        this.test("fn:boolean('')", FALSE);
    }

    public void testBoolean2() {
        this.test("fn:boolean(0)", FALSE);
    }

    public void testBoolean3() {
        this.test("fn:boolean(''^^xsd:string)", FALSE);
    }

    public void testBoolean4() {
        this.test("fn:boolean('X')", TRUE);
    }

    public void testBoolean5() {
        this.test("fn:boolean('X'^^xsd:string)", TRUE);
    }

    public void testBoolean6() {
        this.test("fn:boolean(1)", TRUE);
    }

    public void testBoolean7() {
        this.test("fn:not('')", TRUE);
    }

    public void testBoolean8() {
        this.test("fn:not('X')", FALSE);
    }

    public void testBoolean9() {
        this.test("fn:not(1)", FALSE);
    }

    public void testBoolean10() {
        this.test("fn:not(0)", TRUE);
    }

    public void testStrJoin() {
        this.test("fn:string-join('a', 'b')", NodeValue.makeString("ab"));
    }

    public void testSameTerm1() {
        this.test("sameTerm(1,1)", TRUE);
    }

    public void testSameTerm2() {
        this.test("sameTerm(1,1.0)", FALSE);
    }

    public void testSameTerm3() {
        this.test("sameTerm(1,1e0)", FALSE);
    }

    public void testSameTerm4() {
        this.test("sameTerm(<_:a>, <_:a>)", TRUE);
    }

    public void testSameTerm5() {
        this.test("sameTerm(<x>, <x>)", TRUE);
    }

    public void testSameTerm6() {
        this.test("sameTerm(<x>, <y>)", FALSE);
    }

    private void test(String exprStr, NodeValue result) {
        Expr expr = ExprUtils.parse(exprStr);
        NodeValue r = expr.eval(null, FunctionEnvBase.createTest());
        TS_Functions.assertEquals((Object)result, (Object)r);
    }

    private void testEvalExceptiion(String exprStr) {
        Expr expr = ExprUtils.parse(exprStr);
        try {
            NodeValue r = expr.eval(null, FunctionEnvBase.createTest());
            TS_Functions.fail((String)"No exception raised");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }
}

