/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.ConnectedGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphEdge;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Constants;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.List;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestHeuristicWeightEdge
extends TestCase {
    private String heuristic;
    private BasicPattern pattern;
    private double weight;
    private static Model testsM;
    private static Model graphM;
    private static Context context;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";
    private static final String testCaseFileName = "testing/Optimizer/TestHeuristicWeightEdge-manifest.n3";

    public TestHeuristicWeightEdge(String title, String heuristic, BasicPattern pattern, double weight) {
        super(title);
        this.heuristic = heuristic;
        this.pattern = pattern;
        this.weight = weight;
    }

    public static void oneTimeSetUp() {
        context.set(Constants.PF, ProbabilityFactory.createDefaultModel(Util.readModel(testDataFileName), null));
    }

    public static void oneTimeTearDown() {
        graphM.close();
        testsM.close();
    }

    public void runTest() {
        BasicPatternGraph graph = new BasicPatternGraph(this.pattern, Util.getHeuristic(this.heuristic, context, graphM.getGraph()));
        ConnectedGraph component = graph.getComponent(0);
        if (component == null) {
            return;
        }
        List edges = component.getEdges();
        if (edges.size() == 0) {
            return;
        }
        GraphEdge edge = (GraphEdge)edges.iterator().next();
        TestHeuristicWeightEdge.assertTrue((edge.weight() == this.weight ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test suite() {
        TestSuite ts = new TestSuite("TestHeuristicWeightEdge");
        testsM = Util.readModel(testCaseFileName);
        graphM = Util.readModel(testDataFileName);
        QueryExecution qe = QueryExecutionFactory.create(TestHeuristicWeightEdge.queryTestCases(), testsM);
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution solution = rs.nextSolution();
                String title = solution.getLiteral("title").getLexicalForm();
                String heuristic = solution.getLiteral("heuristic").getLexicalForm();
                Seq edgeR = testsM.getSeq(solution.getResource("edge"));
                double weight = solution.getLiteral("weight").getDouble();
                BasicPattern pattern = TestHeuristicWeightEdge.getBasicPattern(edgeR);
                ts.addTest((Test)new TestHeuristicWeightEdge(title, heuristic, pattern, weight));
            }
        }
        finally {
            qe.close();
        }
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestHeuristicWeightEdge.oneTimeSetUp();
            }

            protected void tearDown() {
                TestHeuristicWeightEdge.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    private static BasicPattern getBasicPattern(Seq edgeR) {
        BasicPattern pattern = new BasicPattern();
        NodeIterator iter = edgeR.iterator();
        while (iter.hasNext()) {
            String[] triple = ((Literal)iter.next()).getLexicalForm().split(" ");
            pattern.add(new Triple(Util.createNode(triple[0]), Util.createNode(triple[1]), Util.createNode(triple[2])));
        }
        return pattern;
    }

    private static String queryTestCases() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dc: <http://purl.org/dc/elements/1.1/>PREFIX : <http://www.w3.org/2006/03/test-description#>SELECT ?title ?heuristic ?edge ?weight WHERE {?tc rdf:type :TestCase .?tc dc:title ?title .?tc :heuristic ?heuristic .?tc :edge ?edge .?tc :weight ?weight .}ORDER BY ASC(?title)";
    }

    static {
        context = ARQ.getContext();
    }
}

