/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Member;
import com.hazelcast.monitor.LocalQueueStats;
import java.io.Serializable;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedQueueStatsCallable
implements Callable<MemberQueueStats>,
Serializable,
HazelcastInstanceAware {
    private String qName;
    private transient HazelcastInstance hzInstance;

    public DistributedQueueStatsCallable(String qName) {
        this.qName = qName;
    }

    @Override
    public MemberQueueStats call() throws Exception {
        IQueue queue = this.hzInstance.getQueue(this.qName);
        LocalQueueStats localMapStats = queue.getLocalQueueStats();
        Member member = this.hzInstance.getCluster().getLocalMember();
        return new MemberQueueStats(member, localMapStats);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hzInstance = hazelcastInstance;
    }

    public static class MemberQueueStats
    implements Serializable {
        Member member;
        LocalQueueStats localQueueStats;

        public MemberQueueStats(Member member, LocalQueueStats localQueueStats) {
            this.member = member;
            this.localQueueStats = localQueueStats;
        }

        public Member getMember() {
            return this.member;
        }

        public void setMember(Member member) {
            this.member = member;
        }

        public LocalQueueStats getLocalQueueStats() {
            return this.localQueueStats;
        }

        public void setLocalQueueStats(LocalQueueStats localQueueStats) {
            this.localQueueStats = localQueueStats;
        }
    }
}

