/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.QueueClientProxy;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueItemIterator<E>
implements Iterator<E> {
    private E[] entries;
    private int current;
    private QueueClientProxy<E> queueProxy;
    private volatile boolean removeCalled = false;

    public QueueItemIterator(E[] entries, QueueClientProxy<E> queueClientProxy) {
        this.entries = entries;
        this.queueProxy = queueClientProxy;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        return this.entries.length > this.current;
    }

    @Override
    public E next() {
        if (this.entries.length <= this.current) {
            throw new NoSuchElementException();
        }
        E entry = this.entries[this.current];
        ++this.current;
        this.removeCalled = false;
        return entry;
    }

    @Override
    public void remove() {
        if (this.current <= 0) {
            throw new IllegalStateException("next() method has not yet been called");
        }
        if (this.removeCalled) {
            throw new IllegalStateException("remove() method has allready bean called");
        }
        this.removeCalled = true;
        this.queueProxy.remove(this.entries[this.current - 1]);
    }
}

