/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBLoader;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import java.util.List;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;

public class tdbloader
extends CmdTDBGraph {
    private boolean showProgress = true;

    public static void main(String ... argv) {
        CmdTDB.init();
        TDB.setOptimizerWarningFlag(false);
        new tdbloader(argv).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    protected String getSummary() {
        return this.getCommandName() + " [--desc DATASET | -loc DIR] FILE ...";
    }

    protected void exec() {
        List urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if ((urls = this.getPositional()).size() == 0) {
            urls.add("-");
        }
        if (this.graphName == null) {
            this.loadQuads(urls);
            return;
        }
        for (String url : urls) {
            Lang lang = RDFLanguages.filenameToLang((String)url);
            if (lang == null || !RDFLanguages.isQuads((Lang)lang)) continue;
            System.err.println("Warning: Quads format given - only the default graph is loaded into the graph for --graph");
            break;
        }
        this.loadNamedGraph(urls);
    }

    void loadNamedGraph(List<String> urls) {
        GraphTDB graph = this.getGraph();
        TDBLoader.load(graph, urls, this.showProgress);
    }

    void loadQuads(List<String> urls) {
        TDBLoader.load(this.getDatasetGraphTDB(), urls, this.showProgress);
    }
}

