/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestUnion
extends GraphTestBase {
    public TestUnion(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestUnion.class);
    }

    public void testUnion() {
        Graph g1 = TestUnion.graphWith("x R y; p R q");
        Graph g2 = TestUnion.graphWith("r A s; x R y");
        Union u = new Union(g1, g2);
        TestUnion.assertContains("Union", "x R y", (Graph)u);
        TestUnion.assertContains("Union", "p R q", (Graph)u);
        TestUnion.assertContains("Union", "r A s", (Graph)u);
        if (u.size() != 3) {
            TestUnion.fail((String)"oops: size of union is not 3");
        }
        u.add(TestUnion.triple("cats eat cheese"));
        TestUnion.assertContains("Union", "cats eat cheese", (Graph)u);
        if (!TestUnion.contains(g1, "cats eat cheese") && !TestUnion.contains(g2, "cats eat cheese")) {
            TestUnion.fail((String)"oops: neither g1 nor g2 contains `cats eat cheese`");
        }
    }
}

