/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.Reader;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.JSONStreamParser;
import net.minidev.json.parser.JSONStringParser;
import net.minidev.json.parser.ParseException;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 144;
    public static final int MODE_JSON_SIMPLE = 192;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 192 : -1;
    private int mode;
    private JSONStreamParser pStream;
    private JSONStringParser pString;

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int permissifMode) {
        this.mode = permissifMode;
    }

    public Object parse(String in) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONStringParser(this.mode);
        }
        return this.pString.parse(in);
    }

    public Object parse(String in, ContainerFactory containerFactory) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONStringParser(this.mode);
        }
        return this.pString.parse(in, containerFactory);
    }

    public Object parse(String in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        if (this.pString == null) {
            this.pString = new JSONStringParser(this.mode);
        }
        return this.pString.parse(in, containerFactory, handler);
    }

    public Object parse(Reader in) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONStreamParser(this.mode);
        }
        return this.pStream.parse(in);
    }

    public Object parse(Reader in, ContainerFactory containerFactory) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONStreamParser(this.mode);
        }
        return this.pStream.parse(in, containerFactory);
    }

    public Object parse(Reader in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        if (this.pStream == null) {
            this.pStream = new JSONStreamParser(this.mode);
        }
        return this.pStream.parse(in, containerFactory);
    }
}

