/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerDumy;
import net.minidev.json.parser.JSONBaseParser;
import net.minidev.json.parser.ParseException;

class JSONStreamParser
extends JSONBaseParser {
    public static final int EOI = -1;
    private int c;
    private Reader in;

    public JSONStreamParser(int permissifMode) {
        super(permissifMode);
    }

    public Object parse(Reader in) throws ParseException {
        return this.parse(in, ContainerFactory.FACTORY_SIMPLE, ContentHandlerDumy.HANDLER);
    }

    public Object parse(Reader in, ContainerFactory containerFactory) throws ParseException {
        return this.parse(in, containerFactory, ContentHandlerDumy.HANDLER);
    }

    public Object parse(Reader in, ContainerFactory containerFactory, ContentHandler handler) throws ParseException {
        Object result;
        this.in = in;
        this.containerFactory = containerFactory;
        this.handler = handler;
        this.pos = 0;
        try {
            this.c = in.read();
            handler.startJSON();
            result = this.readMain(stopX);
            handler.endJSON();
        }
        catch (IOException e) {
            throw new ParseException(this.pos, (Throwable)e);
        }
        this.xs = null;
        this.xo = null;
        return result;
    }

    private final void read() throws IOException {
        this.c = this.in.read();
        ++this.pos;
    }

    private List<Object> readArray() throws ParseException, IOException {
        List<Object> obj = this.containerFactory.createArrayContainer();
        if (this.c != 91) {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        boolean needData = false;
        this.handler.startArray();
        block7: while (true) {
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block7;
                }
                case 93: {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf((char)this.c));
                    }
                    this.read();
                    this.handler.endArray();
                    return obj;
                }
                case 58: 
                case 125: {
                    throw new ParseException(this.pos, 0, Character.valueOf((char)this.c));
                }
                case 44: {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf((char)this.c));
                    }
                    this.read();
                    needData = true;
                    continue block7;
                }
                case -1: {
                    throw new ParseException(this.pos - 1, 3, "EOF");
                }
            }
            obj.add(this.readMain(stopArray));
            needData = false;
        }
    }

    private Object readMain(boolean[] stop) throws ParseException, IOException {
        block12: while (true) {
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block12;
                }
                case 58: 
                case 93: 
                case 125: {
                    throw new ParseException(this.pos, 0, this.c);
                }
                case 123: {
                    return this.readObject();
                }
                case 91: {
                    return this.readArray();
                }
                case 34: 
                case 39: {
                    this.xs = this.readString();
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 110: {
                    this.xs = this.readNQString(stop);
                    if ("null".equals(this.xs)) {
                        this.handler.primitive(null);
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 102: {
                    this.xs = this.readNQString(stop);
                    if ("false".equals(this.xs)) {
                        this.handler.primitive(Boolean.FALSE);
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 116: {
                    this.xs = this.readNQString(stop);
                    if ("true".equals(this.xs)) {
                        this.handler.primitive(Boolean.TRUE);
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 78: {
                    this.xs = this.readNQString(stop);
                    if (!this.acceptNaN) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    if ("NaN".equals(this.xs)) {
                        this.handler.primitive(Float.valueOf(Float.NaN));
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(this.pos, 1, this.xs);
                    }
                    this.handler.primitive(this.xs);
                    return this.xs;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.xo = this.readNumber(stop);
                    this.handler.primitive(this.xo);
                    return this.xo;
                }
            }
            break;
        }
        this.xs = this.readNQString(stop);
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        this.handler.primitive(this.xs);
        return this.xs;
    }

    private String readNQString(boolean[] stop) throws IOException {
        this.sb.clear();
        this.skipNQString(stop);
        return this.sb.toString().trim();
    }

    private Object readNumber(boolean[] stop) throws ParseException, IOException {
        this.sb.clear();
        this.sb.append(this.c);
        this.read();
        this.skipDigits();
        if (this.c != 46 && this.c != 69 && this.c != 101) {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                this.xs = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.sb.toString().trim();
            return this.parseNumber(this.xs);
        }
        if (this.c == 46) {
            this.sb.append(this.c);
            this.read();
            this.skipDigits();
        }
        if (this.c != 69 && this.c != 101) {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                this.xs = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.sb.toString().trim();
            if (!this.acceptLeadinZero) {
                this.checkLeadinZero();
            }
            if (!this.useHiPrecisionFloat) {
                return Float.valueOf(Float.parseFloat(this.xs));
            }
            if (this.xs.length() > 18) {
                return new BigDecimal(this.xs);
            }
            return Double.parseDouble(this.xs);
        }
        this.sb.append('E');
        this.read();
        if (this.c == 43 || this.c == 45 || this.c >= 48 && this.c <= 57) {
            this.sb.append(this.c);
            this.read();
            this.skipDigits();
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                this.xs = this.sb.toString().trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, this.xs);
                }
                return this.xs;
            }
            this.xs = this.sb.toString().trim();
            if (!this.useHiPrecisionFloat) {
                return Float.valueOf(Float.parseFloat(this.xs));
            }
            return Double.parseDouble(this.xs);
        }
        this.skipNQString(stop);
        this.xs = this.sb.toString().trim();
        if (!this.acceptNonQuote) {
            throw new ParseException(this.pos, 1, this.xs);
        }
        if (!this.acceptLeadinZero) {
            this.checkLeadinZero();
        }
        return this.xs;
    }

    private Map<String, Object> readObject() throws ParseException, IOException {
        Map<String, Object> obj = this.containerFactory.createObjectContainer();
        if (this.c != 123) {
            throw new RuntimeException("Internal Error");
        }
        this.handler.startObject();
        boolean needData = false;
        block6: while (true) {
            String key;
            this.read();
            switch (this.c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block6;
                }
                case 58: 
                case 91: 
                case 93: 
                case 123: {
                    throw new ParseException(this.pos, 0, this.c);
                }
                case 125: {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf((char)this.c));
                    }
                    this.read();
                    this.handler.endObject();
                    return obj;
                }
                case 44: {
                    if (needData && !this.acceptUselessComma) {
                        throw new ParseException(this.pos, 0, Character.valueOf((char)this.c));
                    }
                    needData = true;
                    continue block6;
                }
            }
            int keyStart = this.pos;
            if (this.c == 34 || this.c == 39) {
                key = this.readString();
            } else {
                key = this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(this.pos, 1, key);
                }
            }
            this.handler.startObjectEntry(key);
            while (this.c != 58 && this.c != -1) {
                this.read();
            }
            if (this.c == -1) {
                throw new ParseException(this.pos - 1, 3, null);
            }
            this.read();
            Object duplicate = obj.put(key, this.readMain(stopValue));
            if (duplicate != null) {
                throw new ParseException(keyStart, 5, key);
            }
            this.handler.endObjectEntry();
            if (this.c == 125) {
                this.read();
                this.handler.endObject();
                return obj;
            }
            if (this.c == 44) {
                needData = true;
                continue;
            }
            needData = false;
        }
    }

    private String readString() throws ParseException, IOException {
        if (!this.acceptSimpleQuote && this.c == 39) {
            if (this.acceptNonQuote) {
                return this.readNQString(stopAll);
            }
            throw new ParseException(this.pos, 0, this.c);
        }
        this.sb.clear();
        char sep = (char)this.c;
        block18: while (true) {
            this.read();
            switch (this.c) {
                case -1: {
                    throw new ParseException(this.pos - 1, 3, null);
                }
                case 34: 
                case 39: {
                    if (sep == this.c) {
                        this.read();
                        return this.sb.toString();
                    }
                    this.sb.append(this.c);
                    continue block18;
                }
                case 92: {
                    this.read();
                    switch (this.c) {
                        case 116: {
                            this.sb.append('\t');
                            continue block18;
                        }
                        case 110: {
                            this.sb.append('\n');
                            continue block18;
                        }
                        case 114: {
                            this.sb.append('\r');
                            continue block18;
                        }
                        case 102: {
                            this.sb.append('\f');
                            continue block18;
                        }
                        case 98: {
                            this.sb.append('\b');
                            continue block18;
                        }
                        case 92: {
                            this.sb.append('\\');
                            continue block18;
                        }
                        case 47: {
                            this.sb.append('/');
                            continue block18;
                        }
                        case 39: {
                            this.sb.append('\'');
                            continue block18;
                        }
                        case 34: {
                            this.sb.append('\"');
                            continue block18;
                        }
                        case 117: {
                            this.sb.append(this.readUnicode());
                            continue block18;
                        }
                    }
                    continue block18;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 127: {
                    if (this.ignoreControlChar) continue block18;
                    throw new ParseException(this.pos, 0, this.c);
                }
            }
            this.sb.append(this.c);
        }
    }

    private char readUnicode() throws ParseException, IOException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value *= 16;
            this.read();
            if (this.c >= 48 && this.c <= 57) {
                value += this.c - 48;
                continue;
            }
            if (this.c >= 65 && this.c <= 70) {
                value += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 97 && this.c <= 102) {
                value += this.c - 97 + 10;
                continue;
            }
            if (this.c == -1) {
                throw new ParseException(this.pos, 3, "EOF");
            }
            throw new ParseException(this.pos, 4, this.c);
        }
        return (char)value;
    }

    private void skipDigits() throws IOException {
        while (this.c != -1) {
            if (this.c < 48 || this.c > 57) {
                return;
            }
            this.sb.append(this.c);
            this.read();
        }
        return;
    }

    private void skipNQString(boolean[] stop) throws IOException {
        while (this.c != -1) {
            if (this.c >= 0 && this.c <= 125 && stop[this.c]) {
                return;
            }
            this.sb.append(this.c);
            this.read();
        }
        return;
    }

    private void skipSpace() throws IOException {
        while (this.c != -1) {
            if (this.c != 32 && this.c != 13 && this.c != 9 && this.c != 10) {
                return;
            }
            this.sb.append(this.c);
            this.read();
        }
        return;
    }
}

