/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import net.minidev.json.JSONStyle;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ParseException;

public class JSONStyler
extends JSONStyle
implements ContentHandler {
    int deep = 0;
    Appendable out;
    String[] indent;

    public JSONStyler(int FLAG) {
        super(FLAG);
        this.setIdentLevel(2);
    }

    public JSONStyler(int FLAG, int nbLevel) {
        super(FLAG);
        this.setIdentLevel(nbLevel);
    }

    public void setOutput(Appendable out) {
        this.out = out;
    }

    public void setIdentLevel(int nbLevel) {
        String[] indent = new String[nbLevel];
        StringBuilder sb = new StringBuilder("\n");
        for (int i = 0; i < nbLevel; ++i) {
            indent[i] = sb.toString();
            sb.append(' ');
        }
        this.indent = indent;
    }

    public JSONStyler() {
    }

    @Override
    public boolean indent() {
        return true;
    }

    public String getNewLine() {
        if (this.deep <= 0) {
            return "";
        }
        if (this.deep < this.indent.length) {
            return this.indent[this.deep];
        }
        return this.indent[this.deep - 1];
    }

    public JSONStyler getStyler() {
        return this;
    }

    @Override
    public void startJSON() throws ParseException {
    }

    @Override
    public void endJSON() throws ParseException {
    }

    @Override
    public boolean startObject() throws ParseException {
        ++this.deep;
        return false;
    }

    @Override
    public boolean endObject() throws ParseException {
        --this.deep;
        return false;
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException {
        return false;
    }

    @Override
    public boolean endObjectEntry() throws ParseException {
        return false;
    }

    @Override
    public boolean startArray() throws ParseException {
        ++this.deep;
        return false;
    }

    @Override
    public boolean endArray() throws ParseException {
        --this.deep;
        return false;
    }

    @Override
    public boolean primitive(Object value) throws ParseException {
        return false;
    }
}

