/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.testing;

import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.LoggingConfigLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.configuration.ConfigUtil;
import edu.uiuc.ncsa.security.util.testing.TestData;
import edu.uiuc.ncsa.security.util.testing.TestEnvironment;
import edu.uiuc.ncsa.security.util.testing.TestMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class TestConfigLoader<T extends TestEnvironment>
extends LoggingConfigLoader<T> {
    public static final String TESTS_TAG = "tests";
    public static final String TEST_TAG = "test";
    public static final String TEST_NAME_TAG = "name";
    public static final String TEST_ENABLE_TAG = "enabled";
    public static final String DATA_TAG = "data";
    public static final String DATA_TYPE_TAG = "type";
    public static final String LIST_DATA_TYPE_TAG = "list";
    public static final String DATA_NAME_TAG = "name";
    public static final String CONFIG_FILE_KEY = "test:config.file";
    public static final String CONFIG_NAME_KEY = "test:config.name";

    public TestConfigLoader(ConfigurationNode node) {
        super(node);
    }

    public TestConfigLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public static void main(String[] args) {
        ConfigurationNode cn = ConfigUtil.findConfiguration(args[0], args[1], TESTS_TAG);
        TestConfigLoader<TestEnvironment> t = new TestConfigLoader<TestEnvironment>(cn){

            public String getVersionString() {
                return "1.0";
            }
        };
        AbstractEnvironment testEnvironment = t.load();
        System.out.println("Test size=" + testEnvironment.getTestMap().size());
    }

    public T load() {
        TestMap testMap = new TestMap();
        List kids = this.cn.getChildren(TEST_TAG);
        for (ConfigurationNode c : kids) {
            TestData data = new TestData();
            String content = "";
            String attribName = null;
            String attribValue = null;
            String testName = "";
            data.put("test:enabled", Boolean.TRUE);
            boolean hasName = false;
            for (int i = 0; i < c.getAttributeCount(); ++i) {
                attribName = c.getAttribute(i).getName();
                attribValue = c.getAttribute(i).getValue().toString();
                if (attribName.equals("name")) {
                    hasName = true;
                    testName = attribValue;
                }
                if (!attribName.equals(TEST_ENABLE_TAG)) continue;
                data.put("test:enabled", Boolean.parseBoolean(attribValue));
            }
            if (!hasName) {
                throw new IllegalStateException("Error: The test has no name. Cannot process.");
            }
            testMap.put(testName, data);
            List dataNodes = c.getChildren(DATA_TAG);
            for (ConfigurationNode dataNode : dataNodes) {
                Object entry = null;
                String name = null;
                boolean isList = false;
                for (int i = 0; i < dataNode.getAttributeCount(); ++i) {
                    attribName = dataNode.getAttribute(i).getName();
                    attribValue = dataNode.getAttribute(i).getValue().toString();
                    Object x = dataNode.getValue();
                    if (x == null) continue;
                    content = x.toString();
                    if (attribName.equals("name")) {
                        name = attribValue;
                    }
                    if (!attribName.equals(DATA_TYPE_TAG) || !attribValue.equals(LIST_DATA_TYPE_TAG)) continue;
                    isList = true;
                }
                if (isList) {
                    LinkedList<String> list = new LinkedList<String>();
                    StringTokenizer st = new StringTokenizer(content, "\n");
                    while (st.hasMoreTokens()) {
                        list.add(st.nextToken().trim());
                    }
                    entry = list;
                } else {
                    entry = content;
                }
                data.put(name, entry);
            }
        }
        TestEnvironment testEnvironment = new TestEnvironment(testMap, this.myLogger);
        return (T)((Object)testEnvironment);
    }

    public T createInstance() {
        return null;
    }
}

