/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.AbstractOA4MPService;
import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPResponse;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.security.KeyPair;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class OA4MPService
extends AbstractOA4MPService {
    public OA4MPService(ClientEnvironment environment) {
        super(environment);
    }

    @Override
    public void preRequestCert(Asset asset, Map additionalParameters) {
        KeyPair keyPair = this.getNextKeyPair();
        MyPKCS10CertRequest certReq = null;
        try {
            certReq = CertUtil.createCertRequest((KeyPair)keyPair);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new GeneralException("Could not create cert request", e);
        }
        asset.setPrivateKey(keyPair.getPrivate());
        asset.setCertReq(certReq);
        additionalParameters.put("certreq", Base64.encodeBase64String((byte[])asset.getCertReq().getEncoded()));
        if (!additionalParameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
            additionalParameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        }
        if (0L <= this.getEnvironment().getCertLifetime()) {
            additionalParameters.put("certlifetime", this.getEnvironment().getCertLifetime());
        }
    }

    @Override
    public void postRequestCert(Asset asset, OA4MPResponse oa4MPResponse) {
    }

    @Override
    public void postGetCert(Asset asset, AssetResponse assetResponse) {
    }

    @Override
    public void preGetCert(Asset asset, Map parameters) {
    }
}

