/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Trigger
extends Serializable,
Cloneable,
Comparable<Trigger> {
    public static final long serialVersionUID = -3904243490805975570L;
    public static final int MISFIRE_INSTRUCTION_SMART_POLICY = 0;
    public static final int MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY = -1;
    public static final int DEFAULT_PRIORITY = 5;

    public TriggerKey getKey();

    public JobKey getJobKey();

    public String getDescription();

    public String getCalendarName();

    public JobDataMap getJobDataMap();

    public int getPriority();

    public boolean mayFireAgain();

    public Date getStartTime();

    public Date getEndTime();

    public Date getNextFireTime();

    public Date getPreviousFireTime();

    public Date getFireTimeAfter(Date var1);

    public Date getFinalFireTime();

    public int getMisfireInstruction();

    public TriggerBuilder<? extends Trigger> getTriggerBuilder();

    public ScheduleBuilder<? extends Trigger> getScheduleBuilder();

    public boolean equals(Object var1);

    @Override
    public int compareTo(Trigger var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TriggerTimeComparator
    implements Comparator<Trigger>,
    Serializable {
        @Override
        public int compare(Trigger trig1, Trigger trig2) {
            int comp;
            Date t1 = trig1.getNextFireTime();
            Date t2 = trig2.getNextFireTime();
            if (t1 != null || t2 != null) {
                if (t1 == null) {
                    return 1;
                }
                if (t2 == null) {
                    return -1;
                }
                if (t1.before(t2)) {
                    return -1;
                }
                if (t1.after(t2)) {
                    return 1;
                }
            }
            if ((comp = trig2.getPriority() - trig1.getPriority()) != 0) {
                return comp;
            }
            return trig1.getKey().compareTo(trig2.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompletedExecutionInstruction {
        NOOP,
        RE_EXECUTE_JOB,
        SET_TRIGGER_COMPLETE,
        DELETE_TRIGGER,
        SET_ALL_JOB_TRIGGERS_COMPLETE,
        SET_TRIGGER_ERROR,
        SET_ALL_JOB_TRIGGERS_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TriggerState {
        NONE,
        NORMAL,
        PAUSED,
        COMPLETE,
        ERROR,
        BLOCKED;

    }
}

