/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ExecutorUtil {
    public static Logger log = LoggerFactory.getLogger(ExecutorUtil.class);

    public static void shutdownNowAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        pool.shutdownNow();
        boolean shutdown = false;
        while (!shutdown) {
            try {
                shutdown = pool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            if (shutdown) continue;
            pool.shutdownNow();
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        ExecutorUtil.shutdownAndAwaitTermination(pool, 60L, TimeUnit.SECONDS);
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeout, TimeUnit timeUnit) {
        pool.shutdown();
        boolean shutdown = false;
        while (!shutdown) {
            try {
                shutdown = pool.awaitTermination(timeout, timeUnit);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            if (shutdown) continue;
            pool.shutdownNow();
        }
    }

    public static ExecutorService newMDCAwareFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareSingleThreadExecutor(ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareCachedThreadPool(ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    @SuppressForbidden(reason="class customizes ThreadPoolExecutor so it can be used instead")
    public static class MDCAwareThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final int MAX_THREAD_NAME_LEN = 512;

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        }

        @Override
        public void execute(final Runnable command) {
            final Map submitterContext = MDC.getCopyOfContextMap();
            String ctxStr = submitterContext != null && !submitterContext.isEmpty() ? submitterContext.toString().replace("/", "//") : "";
            final String submitterContextStr = ctxStr.length() <= 512 ? ctxStr : ctxStr.substring(0, 512);
            final Exception submitterStackTrace = new Exception("Submitter stack trace");
            super.execute(new Runnable(){

                @Override
                public void run() {
                    Map threadContext = MDC.getCopyOfContextMap();
                    Thread currentThread = Thread.currentThread();
                    String oldName = currentThread.getName();
                    if (submitterContext != null && !submitterContext.isEmpty()) {
                        MDC.setContextMap((Map)submitterContext);
                        currentThread.setName(oldName + "-processing-" + submitterContextStr);
                    } else {
                        MDC.clear();
                    }
                    try {
                        command.run();
                    }
                    catch (Throwable t) {
                        if (t instanceof OutOfMemoryError) {
                            throw t;
                        }
                        log.error("Uncaught exception {} thrown by thread: {}", new Object[]{t, currentThread.getName(), submitterStackTrace});
                        throw t;
                    }
                    finally {
                        if (threadContext != null && !threadContext.isEmpty()) {
                            MDC.setContextMap((Map)threadContext);
                        } else {
                            MDC.clear();
                        }
                        currentThread.setName(oldName);
                    }
                }
            });
        }
    }
}

