/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.CriteriaQueryParameterBinder;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeJpaQuery
extends AbstractJpaQuery {
    private final Class<?> domainClass;
    private final PartTree tree;
    private final JpaParameters parameters;
    private final QueryPreparer query;
    private final QueryPreparer countQuery;

    public PartTreeJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        this.domainClass = method.getEntityInformation().getJavaType();
        this.tree = new PartTree(method.getName(), this.domainClass);
        this.parameters = method.getParameters();
        this.countQuery = new CountQueryPreparer(this.parameters.potentiallySortsDynamically());
        this.query = this.tree.isCountProjection() != false ? this.countQuery : new QueryPreparer(this.parameters.potentiallySortsDynamically());
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        return this.query.createQuery(values);
    }

    @Override
    public TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return (TypedQuery)this.countQuery.createQuery(values);
    }

    private class CountQueryPreparer
    extends QueryPreparer {
        public CountQueryPreparer(boolean recreateQueries) {
            super(recreateQueries);
        }

        @Override
        protected JpaQueryCreator createCreator(ParametersParameterAccessor accessor) {
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor == null ? new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters) : new ParameterMetadataProvider(builder, accessor);
            return new JpaCountQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.domainClass, builder, provider);
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bind(query);
        }
    }

    private class QueryPreparer {
        private final CriteriaQuery<?> cachedCriteriaQuery;
        private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;

        public QueryPreparer(boolean recreateQueries) {
            JpaQueryCreator creator = this.createCreator(null);
            this.cachedCriteriaQuery = recreateQueries ? null : (CriteriaQuery)creator.createQuery();
            this.expressions = recreateQueries ? null : creator.getParameterExpressions();
        }

        public Query createQuery(Object[] values) {
            CriteriaQuery criteriaQuery = this.cachedCriteriaQuery;
            List<ParameterMetadataProvider.ParameterMetadata<?>> expressions = this.expressions;
            ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)PartTreeJpaQuery.this.parameters, values);
            if (this.cachedCriteriaQuery == null || accessor.hasBindableNullValue()) {
                JpaQueryCreator creator = this.createCreator(accessor);
                criteriaQuery = (CriteriaQuery)creator.createQuery(this.getDynamicSort(values));
                expressions = creator.getParameterExpressions();
            }
            TypedQuery<?> jpaQuery = this.createQuery(criteriaQuery);
            return this.invokeBinding(this.getBinder(values, expressions), jpaQuery);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TypedQuery<?> createQuery(CriteriaQuery<?> criteriaQuery) {
            if (this.cachedCriteriaQuery != null) {
                CriteriaQuery<?> criteriaQuery2 = this.cachedCriteriaQuery;
                synchronized (criteriaQuery2) {
                    return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
                }
            }
            return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
        }

        protected JpaQueryCreator createCreator(ParametersParameterAccessor accessor) {
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor == null ? new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters) : new ParameterMetadataProvider(builder, accessor);
            return new JpaQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.domainClass, builder, provider);
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bindAndPrepare((Query)query);
        }

        private ParameterBinder getBinder(Object[] values, List<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
            return new CriteriaQueryParameterBinder(PartTreeJpaQuery.this.parameters, values, expressions);
        }

        private Sort getDynamicSort(Object[] values) {
            return PartTreeJpaQuery.this.parameters.potentiallySortsDynamically() ? new ParametersParameterAccessor((Parameters)PartTreeJpaQuery.this.parameters, values).getSort() : null;
        }
    }
}

