/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.BufferingXmlWriter;
import com.ctc.wstx.sw.NonNsStreamWriter;
import com.ctc.wstx.sw.RepairingNsStreamWriter;
import com.ctc.wstx.sw.SimpleNsStreamWriter;
import com.ctc.wstx.sw.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

public final class MinimalOutputFactory
implements OutputConfigFlags {
    protected final boolean mIsMinimal;
    protected final WriterConfig mConfig;

    protected MinimalOutputFactory(boolean isMinimal) {
        this.mIsMinimal = isMinimal;
        this.mConfig = WriterConfig.createJ2MEDefaults();
    }

    public static MinimalOutputFactory newMinimalInstance() {
        return new MinimalOutputFactory(true);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return this.createSW(out, null, null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        return this.createSW(out, null, enc);
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createSW(result);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w) throws XMLStreamException {
        return this.createSW(null, w, null);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w, String enc) throws XMLStreamException {
        return this.createSW(null, w, enc);
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setProperty(String name, Object value) {
        this.mConfig.setProperty(name, value);
    }

    public WriterConfig getConfig() {
        return this.mConfig;
    }

    /*
     * WARNING - void declaration
     */
    private BaseStreamWriter createSW(OutputStream out, Writer w, String enc) throws XMLStreamException {
        void var5_5;
        BufferingXmlWriter xw;
        WriterConfig cfg = this.mConfig.createNonShared();
        if (w == null) {
            enc = enc == null ? "UTF-8" : CharsetNames.normalize(enc);
            try {
                w = new OutputStreamWriter(out, enc);
                xw = new BufferingXmlWriter(w, cfg, enc);
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
        }
        if (enc == null && w instanceof OutputStreamWriter) {
            enc = ((OutputStreamWriter)w).getEncoding();
        }
        try {
            xw = new BufferingXmlWriter(w, cfg, enc);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        if (cfg.willSupportNamespaces()) {
            if (cfg.automaticNamespacesEnabled()) {
                return new RepairingNsStreamWriter((XmlWriter)var5_5, enc, cfg);
            }
            return new SimpleNsStreamWriter((XmlWriter)var5_5, enc, cfg);
        }
        return new NonNsStreamWriter((XmlWriter)var5_5, enc, cfg);
    }

    private BaseStreamWriter createSW(Result res) throws XMLStreamException {
        if (res instanceof StreamResult) {
            StreamResult sr = (StreamResult)res;
            Writer w = sr.getWriter();
            if (w == null) {
                OutputStream out = sr.getOutputStream();
                if (out == null) {
                    throw new XMLStreamException("Can not create StAX writer for a StreamResult -- neither writer nor output stream was set.");
                }
                return this.createSW(out, null, null);
            }
            return this.createSW(null, w, null);
        }
        if (res instanceof SAXResult) {
            throw new XMLStreamException("Can not create a STaX writer for a SAXResult -- not (yet) implemented.");
        }
        if (res instanceof DOMResult) {
            throw new XMLStreamException("Can not create a STaX writer for a DOMResult -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate a writer for XML result type " + res.getClass() + " (unknown type)");
    }
}

