/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.impl.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.ldap.LDAPService;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.impl.v2.NodeRegistryService;
import org.dataone.service.cn.v2.CNIdentity;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InvalidCredentials;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.util.ServiceMethodRestrictionUtil;

public class CNIdentityLDAPImpl
extends LDAPService
implements CNIdentity {
    public static Log log = LogFactory.getLog(CNIdentityLDAPImpl.class);
    private static final Integer DEFULAT_COUNT = new Integer(100);
    private NodeRegistryService nodeRegistryService = new NodeRegistryService();

    public CNIdentityLDAPImpl() {
        this.setBase(Settings.getConfiguration().getString("identity.ldap.base"));
    }

    public void setBase(String base) {
        this.base = base;
    }

    public Subject createGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented, IdentifierNotUnique, InvalidRequest {
        Subject groupName = group.getSubject();
        Subject groupAdmin = session.getSubject();
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("top");
        objClasses.add("groupOfUniqueNames");
        BasicAttribute cn = new BasicAttribute("cn", this.parseAttribute(groupName.getValue(), "cn"));
        BasicAttribute owners = new BasicAttribute("owner");
        owners.add(groupAdmin.getValue());
        if (group.getRightsHolderList() != null) {
            for (Subject rightsHolder : group.getRightsHolderList()) {
                owners.add(rightsHolder.getValue());
            }
        }
        BasicAttribute uniqueMembers = new BasicAttribute("uniqueMember");
        uniqueMembers.add(groupAdmin.getValue());
        if (group.getHasMemberList() != null) {
            for (Subject member : group.getHasMemberList()) {
                boolean memberIsGroup = false;
                try {
                    List values = this.getAttributeValues(member.getValue(), "uniqueMember");
                    if (!values.isEmpty()) {
                        memberIsGroup = true;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Could not check whether member subject is a group: " + e.getMessage()));
                }
                if (memberIsGroup) {
                    throw new InvalidRequest("0000", "Group member: " + member.getValue() + " cannot be another Group");
                }
                uniqueMembers.add(member.getValue());
            }
        }
        String dn = groupName.getValue();
        try {
            DirContext ctx = this.getContext();
            BasicAttributes orig = new BasicAttributes();
            orig.put(objClasses);
            orig.put(cn);
            orig.put(uniqueMembers);
            orig.put(owners);
            ctx.createSubcontext(dn, (Attributes)orig);
            log.debug((Object)("Created group " + dn + "."));
        }
        catch (NameAlreadyBoundException e) {
            String msg = "Group " + dn + " already exists";
            log.warn((Object)msg);
            throw new IdentifierNotUnique("2400", msg);
        }
        catch (NamingException e) {
            throw new ServiceFailure("2490", "Could not create group: " + e.getMessage());
        }
        return groupName;
    }

    public boolean updateGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        Subject groupSubject = group.getSubject();
        SubjectInfo originalGroup = this.getSubjectInfo(session, groupSubject);
        try {
            boolean canEdit = this.canEditGroup(session, groupSubject);
            this.removeSubject(groupSubject);
        }
        catch (NamingException e) {
            ServiceFailure sf = new ServiceFailure("2490", "Could not update group: " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        Throwable createException = null;
        try {
            this.createGroup(session, group);
        }
        catch (IdentifierNotUnique e) {
            createException = e;
        }
        catch (InvalidRequest e) {
            createException = e;
        }
        if (createException != null) {
            try {
                this.createGroup(session, originalGroup.getGroup(0));
            }
            catch (IdentifierNotUnique e) {
                ServiceFailure sf = new ServiceFailure("2490", "Could not recreate original group after update failed: " + e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            if (createException instanceof InvalidRequest) {
                throw (InvalidRequest)createException;
            }
            ServiceFailure sf = new ServiceFailure("2490", "Could not update group: " + createException.getMessage());
            sf.initCause(createException);
            throw sf;
        }
        return true;
    }

    private boolean canEditGroup(Session session, Subject groupName) throws NamingException, NotAuthorized {
        boolean canEdit = false;
        Set sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
        List owners = this.getAttributeValues(groupName.getValue(), "owner");
        block2: for (Subject user : sessionSubjects) {
            String userDN = user.getValue();
            try {
                userDN = CertificateManager.getInstance().standardizeDN(userDN);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (Object ownerObj : owners) {
                String owner = (String)ownerObj;
                owner = CertificateManager.getInstance().standardizeDN(owner);
                if (!userDN.equals(owner)) continue;
                canEdit = true;
                break block2;
            }
        }
        if (!canEdit) {
            throw new NotAuthorized("2560", "Subject not in owner list for group");
        }
        return canEdit;
    }

    private boolean canEditPerson(Session session, Subject personSubject) throws NotAuthorized {
        boolean canEdit = false;
        Set sessionSubjects = null;
        sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
        for (Subject user : sessionSubjects) {
            String sessionDN = user.getValue();
            try {
                sessionDN = CertificateManager.getInstance().standardizeDN(sessionDN);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String listedDN = personSubject.getValue();
            listedDN = CertificateManager.getInstance().standardizeDN(listedDN);
            if (!sessionDN.equals(listedDN)) continue;
            canEdit = true;
            break;
        }
        if (!canEdit) {
            throw new NotAuthorized("4534", "Subject not allowed to edit subject");
        }
        return canEdit;
    }

    public boolean mapIdentity(Session session, Subject primarySubject, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        int failureCount = 0;
        boolean isAllowed = false;
        Subject sessionSubject = null;
        List nodeList = null;
        try {
            nodeList = this.nodeRegistryService.listNodes().getNodeList();
        }
        catch (Exception e) {
            log.warn((Object)"Using D1Client to look up nodeList from CN");
            nodeList = D1Client.getCN().listNodes().getNodeList();
        }
        sessionSubject = session.getSubject();
        isAllowed = ServiceMethodRestrictionUtil.isMethodAllowed((Subject)sessionSubject, (List)nodeList, (String)"CNIdentity", (String)"mapIdentity");
        if (!isAllowed) {
            String sessionSubjectValue = null;
            if (sessionSubject != null) {
                sessionSubjectValue = sessionSubject.getValue();
            }
            throw new NotAuthorized("2360", sessionSubjectValue + " is not allowed to map identities");
        }
        boolean mappingExists = this.checkAttribute(primarySubject.getValue(), "equivalentIdentity", secondarySubject.getValue());
        if (mappingExists) {
            throw new InvalidRequest("", "Account mapping already exists");
        }
        try {
            DirContext ctx = this.getContext();
            ModificationItem[] mods = null;
            BasicAttribute mod0 = null;
            String primaryDN = new LdapName(primarySubject.getValue()).toString();
            String secondaryDN = new LdapName(secondarySubject.getValue()).toString();
            try {
                mods = new ModificationItem[1];
                mod0 = new BasicAttribute("equivalentIdentity", secondaryDN);
                mods[0] = new ModificationItem(1, mod0);
                ctx.modifyAttributes(primaryDN, mods);
                log.debug((Object)("Successfully set equivalentIdentity on: " + primaryDN + " for " + secondaryDN));
            }
            catch (Exception e) {
                log.warn((Object)("Could not set equivalentIdentity on: " + primaryDN + " for " + secondaryDN), (Throwable)e);
                ++failureCount;
            }
            try {
                mods = new ModificationItem[1];
                mod0 = new BasicAttribute("equivalentIdentity", primaryDN);
                mods[0] = new ModificationItem(1, mod0);
                ctx.modifyAttributes(secondaryDN, mods);
                log.debug((Object)("Successfully set equivalentIdentity on: " + secondaryDN + " for " + primaryDN));
            }
            catch (Exception e) {
                log.warn((Object)("Could not set equivalentIdentity on: " + secondaryDN + " for " + primaryDN), (Throwable)e);
                ++failureCount;
            }
        }
        catch (Exception e) {
            throw new ServiceFailure("2390", "Could not map identity: " + e.getMessage());
        }
        if (failureCount > 1) {
            throw new ServiceFailure("2390", "Could not map identity, neither account could be edited.");
        }
        return true;
    }

    public boolean requestMapIdentityBRL(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        try {
            Subject primarySubject = session.getSubject();
            DirContext ctx = this.getContext();
            boolean requestExists = this.checkAttribute(primarySubject.getValue(), "equivalentIdentityRequest", secondarySubject.getValue());
            if (requestExists) {
                throw new InvalidRequest("", "Request already issued for: " + primarySubject.getValue() + " = " + secondarySubject.getValue());
            }
            ModificationItem[] mods = null;
            BasicAttribute mod0 = null;
            mods = new ModificationItem[1];
            mod0 = new BasicAttribute("equivalentIdentityRequest", secondarySubject.getValue());
            mods[0] = new ModificationItem(1, mod0);
            ctx.modifyAttributes(primarySubject.getValue(), mods);
            log.debug((Object)("Successfully set equivalentIdentityRequest on: " + primarySubject.getValue() + " for " + secondarySubject.getValue()));
            boolean subjectExists = false;
            try {
                subjectExists = this.checkAttribute(secondarySubject.getValue(), "cn", "*");
            }
            catch (Exception e) {
                subjectExists = false;
            }
            if (subjectExists && !(requestExists = this.checkAttribute(secondarySubject.getValue(), "equivalentIdentityRequest", primarySubject.getValue()))) {
                mods = null;
                mod0 = null;
                mods = new ModificationItem[1];
                mod0 = new BasicAttribute("equivalentIdentityRequest", primarySubject.getValue());
                mods[0] = new ModificationItem(1, mod0);
                ctx.modifyAttributes(secondarySubject.getValue(), mods);
                log.debug((Object)("Successfully set equivalentIdentityRequest on: " + secondarySubject.getValue() + " for " + primarySubject.getValue()));
            }
        }
        catch (Exception e) {
            throw new ServiceFailure("2390", "Could not request map identity: " + e.getMessage());
        }
        return true;
    }

    public boolean requestMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        try {
            Subject primarySubject = session.getSubject();
            DirContext ctx = this.getContext();
            boolean subjectExists = false;
            boolean confirmationRequested = false;
            try {
                subjectExists = this.checkAttribute(primarySubject.getValue(), "cn", "*");
            }
            catch (Exception e) {
                subjectExists = false;
            }
            if (subjectExists && (confirmationRequested = this.checkAttribute(primarySubject.getValue(), "equivalentIdentityRequest", secondarySubject.getValue()))) {
                throw new InvalidRequest("", "Request already issued for: " + primarySubject.getValue() + " = " + secondarySubject.getValue());
            }
            confirmationRequested = this.checkAttribute(secondarySubject.getValue(), "equivalentIdentityRequest", primarySubject.getValue());
            if (confirmationRequested) {
                throw new InvalidRequest("", "Request already issued for: " + secondarySubject.getValue() + " = " + primarySubject.getValue());
            }
            ModificationItem[] mods = null;
            BasicAttribute mod0 = null;
            mods = new ModificationItem[1];
            mod0 = new BasicAttribute("equivalentIdentityRequest", primarySubject.getValue());
            mods[0] = new ModificationItem(1, mod0);
            ctx.modifyAttributes(secondarySubject.getValue(), mods);
            log.debug((Object)("Successfully set equivalentIdentityRequest on: " + secondarySubject.getValue() + " for " + primarySubject.getValue()));
        }
        catch (Exception e) {
            throw new ServiceFailure("2390", "Could not request map identity: " + e.getMessage());
        }
        return true;
    }

    public boolean confirmMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        block6: {
            try {
                Subject primarySubject = session.getSubject();
                DirContext ctx = this.getContext();
                boolean confirmationRequest = this.checkAttribute(primarySubject.getValue(), "equivalentIdentityRequest", secondarySubject.getValue());
                ModificationItem[] mods = null;
                BasicAttribute mod0 = null;
                if (confirmationRequest) {
                    mods = new ModificationItem[2];
                    mod0 = new BasicAttribute("equivalentIdentity", secondarySubject.getValue());
                    mods[0] = new ModificationItem(1, mod0);
                    BasicAttribute mod1 = new BasicAttribute("equivalentIdentityRequest", secondarySubject.getValue());
                    mods[1] = new ModificationItem(3, mod1);
                    ctx.modifyAttributes(primarySubject.getValue(), mods);
                    log.debug((Object)("Successfully set equivalentIdentity: " + primarySubject.getValue() + " = " + secondarySubject.getValue()));
                    boolean subjectExists = false;
                    try {
                        subjectExists = this.checkAttribute(secondarySubject.getValue(), "cn", "*");
                    }
                    catch (Exception e) {
                        subjectExists = false;
                    }
                    if (subjectExists) {
                        mods = new ModificationItem[1];
                        mod0 = new BasicAttribute("equivalentIdentity", primarySubject.getValue());
                        mods[0] = new ModificationItem(1, mod0);
                        ctx.modifyAttributes(secondarySubject.getValue(), mods);
                        log.debug((Object)("Successfully set reciprocal equivalentIdentity: " + secondarySubject.getValue() + " = " + primarySubject.getValue()));
                    }
                    break block6;
                }
                throw new InvalidRequest("", "There is no identity mapping request to confim on: " + secondarySubject.getValue() + " for " + primarySubject.getValue());
            }
            catch (Exception e) {
                throw new ServiceFailure("2390", "Could not confirm identity mapping: " + e.getMessage());
            }
        }
        return true;
    }

    public Subject updateAccount(Session session, Person p) throws ServiceFailure, InvalidCredentials, NotImplemented, InvalidRequest, NotAuthorized {
        Subject subject = p.getSubject();
        this.canEditPerson(session, subject);
        try {
            String dn = subject.getValue();
            String commonName = this.parseAttribute(dn, "cn");
            if (commonName == null) {
                if (p.getGivenNameList() != null && !p.getGivenNameList().isEmpty()) {
                    commonName = commonName + p.getGivenName(0) + " ";
                }
                commonName = commonName + p.getFamilyName();
            }
            BasicAttribute cn = new BasicAttribute("cn", commonName);
            BasicAttribute sn = new BasicAttribute("sn", p.getFamilyName());
            BasicAttribute givenNames = new BasicAttribute("givenName");
            for (String givenName : p.getGivenNameList()) {
                givenNames.add(givenName);
            }
            BasicAttribute mail = new BasicAttribute("mail");
            for (String email : p.getEmailList()) {
                mail.add(email);
            }
            BasicAttribute isVerified = new BasicAttribute("isVerified", Boolean.FALSE.toString().toUpperCase());
            DirContext ctx = this.getContext();
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, cn), new ModificationItem(2, sn), new ModificationItem(2, givenNames), new ModificationItem(2, mail), new ModificationItem(2, isVerified)};
            ctx.modifyAttributes(dn, mods);
            log.debug((Object)("Updated entry: " + subject.getValue()));
        }
        catch (Exception e) {
            throw new ServiceFailure("4530", "Could not update account: " + e.getMessage());
        }
        return subject;
    }

    public boolean verifyAccount(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, InvalidToken, InvalidRequest {
        List nodeList = null;
        try {
            nodeList = this.nodeRegistryService.listNodes().getNodeList();
        }
        catch (Exception e) {
            log.warn((Object)"Using D1Client to look up nodeList from CN");
            nodeList = D1Client.getCN().listNodes().getNodeList();
        }
        boolean isAllowed = false;
        Subject sessionSubject = null;
        if (session != null) {
            sessionSubject = session.getSubject();
            isAllowed = ServiceMethodRestrictionUtil.isMethodAllowed((Subject)sessionSubject, (List)nodeList, (String)"CNIdentity", (String)"verifyAccount");
        }
        if (!isAllowed) {
            String sessionSubjectValue = null;
            if (sessionSubject != null) {
                sessionSubjectValue = sessionSubject.getValue();
            }
            throw new NotAuthorized("4541", sessionSubjectValue + " is not allowed to verify identities");
        }
        try {
            DirContext ctx = this.getContext();
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute isVerified = new BasicAttribute("isVerified", Boolean.TRUE.toString().toUpperCase());
            mods[0] = new ModificationItem(2, isVerified);
            ctx.modifyAttributes(subject.getValue(), mods);
            log.debug((Object)("Verified subject: " + subject.getValue()));
        }
        catch (NamingException e) {
            throw new ServiceFailure("4540", "Could not verify account: " + e.getMessage());
        }
        return true;
    }

    public Subject registerAccount(Session session, Person p) throws ServiceFailure, IdentifierNotUnique, InvalidCredentials, NotImplemented, InvalidRequest {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("top");
        objClasses.add("person");
        objClasses.add("organizationalPerson");
        objClasses.add("inetOrgPerson");
        objClasses.add("d1Principal");
        Subject subject = p.getSubject();
        String dn = subject.getValue();
        try {
            this.constructTree(dn);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new ServiceFailure("4520", "Could not counstruct partial tree: " + e.getMessage());
        }
        String commonName = this.parseAttribute(dn, "cn");
        if (commonName == null) {
            if (p.getGivenNameList() != null && !p.getGivenNameList().isEmpty()) {
                commonName = commonName + p.getGivenName(0) + " ";
            }
            commonName = commonName + p.getFamilyName();
        }
        BasicAttribute cn = new BasicAttribute("cn", commonName);
        BasicAttribute sn = new BasicAttribute("sn", p.getFamilyName());
        BasicAttribute givenNames = new BasicAttribute("givenName");
        for (String givenName : p.getGivenNameList()) {
            givenNames.add(givenName);
        }
        BasicAttribute mail = new BasicAttribute("mail");
        if (p.getEmailList() != null) {
            for (String email : p.getEmailList()) {
                mail.add(email);
            }
        }
        BasicAttribute isVerified = new BasicAttribute("isVerified", Boolean.FALSE.toString().toUpperCase());
        try {
            DirContext ctx = this.getContext();
            BasicAttributes orig = new BasicAttributes();
            orig.put(objClasses);
            if (cn.getAll().hasMore()) {
                orig.put(cn);
            }
            if (sn.getAll().hasMore()) {
                orig.put(sn);
            }
            if (givenNames.getAll().hasMore()) {
                orig.put(givenNames);
            }
            if (mail.getAll().hasMore()) {
                orig.put(mail);
            }
            orig.put(isVerified);
            ctx.createSubcontext(dn, (Attributes)orig);
            log.debug((Object)("Added entry " + dn));
        }
        catch (NameAlreadyBoundException e) {
            String msg = "Entry " + dn + " already exists";
            log.warn((Object)msg, (Throwable)e);
            throw new IdentifierNotUnique("4521", msg);
        }
        catch (NamingException e) {
            throw new ServiceFailure("4520", "Could not register account: " + e.getMessage());
        }
        return subject;
    }

    public SubjectInfo getSubjectInfo(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        ArrayList<String> visitedSubjects = new ArrayList<String>();
        visitedSubjects.add(subject.getValue());
        return this.getSubjectInfo(session, subject, true, visitedSubjects);
    }

    private SubjectInfo getSubjectInfo(Session session, Subject subject, boolean recurse, List<String> visitedSubjects) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        boolean redact = this.shouldRedact(session);
        if (redact) {
            if (session != null) {
                log.debug((Object)("subjectInfo requested for: '" + subject.getValue() + "'"));
                log.debug((Object)("checking if redaction holds for the calling user: '" + session.getSubject().getValue() + "'"));
            } else {
                log.debug((Object)"session is null, we will redact email");
            }
            if (session != null && session.getSubject().equals((Object)subject)) {
                log.debug((Object)("subject MATCH. lifting redaction for the calling user: '" + session.getSubject().getValue() + "'"));
                redact = false;
            }
        }
        SubjectInfo subjectInfo = new SubjectInfo();
        String dn = subject.getValue();
        try {
            DirContext ctx = this.getContext();
            Attributes attributes = ctx.getAttributes(dn);
            subjectInfo = this.processAttributes(dn, attributes, recurse, false, redact, visitedSubjects);
            log.debug((Object)("Retrieved SubjectList for: " + dn));
        }
        catch (NameNotFoundException ex) {
            log.warn((Object)("Could not find: " + dn + " : in Ldap: " + ex.getMessage()));
            throw new NotFound("4564", ex.getMessage());
        }
        catch (Exception e) {
            String msg = "Problem looking up entry: " + dn + " : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new ServiceFailure("4561", msg);
        }
        return subjectInfo;
    }

    protected List<Group> lookupGroups(String personDn) throws ServiceFailure {
        boolean redact = false;
        SubjectInfo pList = new SubjectInfo();
        try {
            DirContext ctx = this.getContext();
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String searchCriteria = "(&(objectClass=groupOfUniqueNames)(uniqueMember=" + personDn + "))";
            NamingEnumeration<SearchResult> results = ctx.search(this.base, searchCriteria, ctls);
            ArrayList<String> visitedSubjects = new ArrayList<String>();
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String dn = si.getNameInNamespace();
                log.debug((Object)("Search result found for: " + dn));
                Attributes attrs = si.getAttributes();
                visitedSubjects.add(dn);
                SubjectInfo resultList = this.processAttributes(dn, attrs, false, false, redact, visitedSubjects);
                if (resultList == null) continue;
                for (Group group : resultList.getGroupList()) {
                    pList.addGroup(group);
                }
            }
        }
        catch (Exception e) {
            String msg = "Problem looking up group membership at base: " + this.base + " : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new ServiceFailure("2290", msg);
        }
        return pList.getGroupList();
    }

    public SubjectInfo listSubjects(Session session, String query, String status, Integer start, Integer count) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        boolean redact = this.shouldRedact(session);
        if (start == null || start < 0) {
            start = 0;
        }
        log.info((Object)("The start index is " + start));
        if (count == null || count <= 0) {
            log.info((Object)"The count is null or equal or less than 0===================");
            count = DEFULAT_COUNT;
            log.info((Object)("the count value is ===============" + count));
        } else {
            log.info((Object)"The count is not null or a positive number===================");
            log.info((Object)("the count value is ===============" + count));
        }
        SubjectInfo pList = new SubjectInfo();
        try {
            DirContext ctx = this.getContext();
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String searchCriteria = "(|(objectClass=d1Principal)(objectClass=groupOfUniqueNames))";
            if (query != null && query.length() > 0) {
                String queryCriteria = "(|(dn=*" + query + "*)" + "(cn=*" + query + "*)" + "(sn=*" + query + "*)" + "(givenName=*" + query + "*)" + "(mail=*" + query + "*)" + ")";
                searchCriteria = "(&" + queryCriteria + searchCriteria + ")";
            }
            if (status != null) {
                Boolean isVerified = new Boolean(status.equalsIgnoreCase("verified"));
                String statusCriteria = "(isVerified=" + isVerified.toString().toUpperCase() + ")";
                searchCriteria = "(&" + statusCriteria + searchCriteria + ")";
            }
            NamingEnumeration<SearchResult> results = ctx.search(this.base, searchCriteria, ctls);
            int index = 0;
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String dn = si.getNameInNamespace();
                log.debug((Object)("Search result found for: " + dn));
                Attributes attrs = si.getAttributes();
                ArrayList<String> visitedSubjects = new ArrayList<String>();
                visitedSubjects.add(dn);
                SubjectInfo resultList = this.processAttributes(dn, attrs, false, false, redact, visitedSubjects);
                if (resultList == null) continue;
                for (Group group : resultList.getGroupList()) {
                    if (CNIdentityLDAPImpl.contains(pList.getGroupList(), group)) continue;
                    if (index >= start && index < count + start) {
                        pList.addGroup(group);
                    }
                    ++index;
                }
                for (Person person : resultList.getPersonList()) {
                    if (CNIdentityLDAPImpl.contains(pList.getPersonList(), person)) continue;
                    if (index >= start && index < count + start) {
                        pList.addPerson(person);
                    }
                    ++index;
                }
            }
        }
        catch (Exception e) {
            String msg = "Problem listing entries at base: " + this.base + " : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new ServiceFailure("2290", msg);
        }
        return pList;
    }

    private SubjectInfo processAttributes(String name, Attributes attributes, boolean recurse, boolean equivalentIdentityRequestsOnly, boolean redact, List<String> visitedSubjects) throws Exception {
        SubjectInfo pList = new SubjectInfo();
        name = CertificateManager.getInstance().standardizeDN(name);
        if (!visitedSubjects.contains(name)) {
            visitedSubjects.add(name);
        }
        if (attributes != null) {
            NamingEnumeration<?> objectClasses = attributes.get("objectClass").getAll();
            boolean isGroup = true;
            while (objectClasses.hasMore()) {
                String objectClass = (String)objectClasses.next();
                if (!objectClass.equalsIgnoreCase("d1Principal")) continue;
                isGroup = false;
                break;
            }
            NamingEnumeration<? extends Attribute> values = attributes.getAll();
            NamingEnumeration<?> items = null;
            if (isGroup) {
                Group group = new Group();
                Subject subject = new Subject();
                subject.setValue(name);
                group.setSubject(subject);
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID();
                    String attributeValue = null;
                    if (attributeName.equalsIgnoreCase("cn")) {
                        attributeValue = (String)attribute.get();
                        group.setGroupName(attributeValue);
                        log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                    }
                    if (attributeName.equalsIgnoreCase("owner")) {
                        items = attribute.getAll();
                        while (items.hasMore()) {
                            attributeValue = (String)items.next();
                            attributeValue = CertificateManager.getInstance().standardizeDN(attributeValue);
                            log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                            Subject owner = new Subject();
                            owner.setValue(attributeValue);
                            group.addRightsHolder(owner);
                        }
                    }
                    if (!attributeName.equalsIgnoreCase("uniqueMember")) continue;
                    items = attribute.getAll();
                    while (items.hasMore()) {
                        attributeValue = (String)items.next();
                        attributeValue = CertificateManager.getInstance().standardizeDN(attributeValue);
                        Subject member = new Subject();
                        member.setValue(attributeValue);
                        group.addHasMember(member);
                        log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                        if (!recurse) continue;
                        SubjectInfo groupInfo = this.getSubjectInfo(null, member, false, visitedSubjects);
                        if (groupInfo.getPersonList() != null) {
                            for (Person p : groupInfo.getPersonList()) {
                                if (CNIdentityLDAPImpl.contains(pList.getPersonList(), p)) continue;
                                pList.addPerson(p);
                            }
                        }
                        if (groupInfo.getGroupList() == null) continue;
                        for (Group g : groupInfo.getGroupList()) {
                            if (CNIdentityLDAPImpl.contains(pList.getGroupList(), g)) continue;
                            pList.addGroup(g);
                        }
                    }
                }
                if (!CNIdentityLDAPImpl.contains(pList.getGroupList(), group)) {
                    pList.getGroupList().add(0, group);
                }
            } else {
                Person person = new Person();
                Subject subject = new Subject();
                subject.setValue(name);
                person.setSubject(subject);
                while (values.hasMore()) {
                    Person placeholderPerson;
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID();
                    String attributeValue = null;
                    if (attributeName.equalsIgnoreCase("cn")) {
                        attributeValue = (String)attribute.get();
                        log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                    }
                    if (attributeName.equalsIgnoreCase("sn")) {
                        attributeValue = (String)attribute.get();
                        person.setFamilyName(attributeValue);
                        log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                    }
                    if (attributeName.equalsIgnoreCase("mail") && !redact) {
                        items = attribute.getAll();
                        while (items.hasMore()) {
                            attributeValue = (String)items.next();
                            person.addEmail(attributeValue);
                            log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                        }
                    }
                    if (attributeName.equalsIgnoreCase("givenName")) {
                        items = attribute.getAll();
                        while (items.hasMore()) {
                            attributeValue = (String)items.next();
                            person.addGivenName(attributeValue);
                            log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                        }
                    }
                    if (attributeName.equalsIgnoreCase("isVerified")) {
                        attributeValue = (String)attribute.get();
                        person.setVerified(Boolean.valueOf(Boolean.parseBoolean(attributeValue)));
                        log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                    }
                    if (equivalentIdentityRequestsOnly) {
                        if (!attributeName.equalsIgnoreCase("equivalentIdentityRequest")) continue;
                        items = attribute.getAll();
                        while (items.hasMore()) {
                            attributeValue = (String)items.next();
                            try {
                                attributeValue = CertificateManager.getInstance().standardizeDN(attributeValue);
                            }
                            catch (Exception e) {
                                Subject equivalentIdentityRequest = new Subject();
                                equivalentIdentityRequest.setValue(attributeValue);
                                placeholderPerson = new Person();
                                placeholderPerson.setSubject(equivalentIdentityRequest);
                                placeholderPerson.addEmail("NA");
                                placeholderPerson.addGivenName("NA");
                                placeholderPerson.setFamilyName("NA");
                                if (CNIdentityLDAPImpl.contains(pList.getPersonList(), placeholderPerson)) continue;
                                pList.addPerson(placeholderPerson);
                                continue;
                            }
                            Subject equivalentIdentityRequest = new Subject();
                            equivalentIdentityRequest.setValue(attributeValue);
                            log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                            if (!recurse || visitedSubjects != null && visitedSubjects.contains(equivalentIdentityRequest.getValue())) continue;
                            try {
                                SubjectInfo equivalentIdentityRequestInfo = this.getSubjectInfo(null, equivalentIdentityRequest, true, visitedSubjects);
                                if (equivalentIdentityRequestInfo.getPersonList() != null) {
                                    for (Person p : equivalentIdentityRequestInfo.getPersonList()) {
                                        if (CNIdentityLDAPImpl.contains(pList.getPersonList(), p)) continue;
                                        pList.addPerson(p);
                                    }
                                }
                                if (equivalentIdentityRequestInfo.getGroupList() == null) continue;
                                for (Group g : equivalentIdentityRequestInfo.getGroupList()) {
                                    if (CNIdentityLDAPImpl.contains(pList.getGroupList(), g)) continue;
                                    pList.addGroup(g);
                                }
                            }
                            catch (NotFound e) {
                                log.warn((Object)("No account found for equivalentIdentityRequest entry: " + equivalentIdentityRequest.getValue()), (Throwable)e);
                                placeholderPerson = new Person();
                                placeholderPerson.setSubject(equivalentIdentityRequest);
                                placeholderPerson.addEmail("NA");
                                placeholderPerson.addGivenName("NA");
                                placeholderPerson.setFamilyName("NA");
                                if (CNIdentityLDAPImpl.contains(pList.getPersonList(), placeholderPerson)) continue;
                                pList.addPerson(placeholderPerson);
                            }
                        }
                        continue;
                    }
                    if (!attributeName.equalsIgnoreCase("equivalentIdentity")) continue;
                    items = attribute.getAll();
                    while (items.hasMore()) {
                        attributeValue = (String)items.next();
                        log.debug((Object)("Found attribute: " + attributeName + "=" + attributeValue));
                        Subject equivalentIdentity = new Subject();
                        try {
                            attributeValue = CertificateManager.getInstance().standardizeDN(attributeValue);
                        }
                        catch (Exception e) {
                            equivalentIdentity.setValue(attributeValue);
                            person.addEquivalentIdentity(equivalentIdentity);
                            continue;
                        }
                        equivalentIdentity.setValue(attributeValue);
                        person.addEquivalentIdentity(equivalentIdentity);
                        if (!recurse || visitedSubjects != null && visitedSubjects.contains(equivalentIdentity.getValue())) continue;
                        try {
                            SubjectInfo equivalentIdentityInfo = this.getSubjectInfo(null, equivalentIdentity, true, visitedSubjects);
                            if (equivalentIdentityInfo.getPersonList() != null) {
                                for (Person p : equivalentIdentityInfo.getPersonList()) {
                                    if (CNIdentityLDAPImpl.contains(pList.getPersonList(), p)) continue;
                                    pList.addPerson(p);
                                }
                            }
                            if (equivalentIdentityInfo.getGroupList() == null) continue;
                            for (Group g : equivalentIdentityInfo.getGroupList()) {
                                if (CNIdentityLDAPImpl.contains(pList.getGroupList(), g)) continue;
                                pList.addGroup(g);
                            }
                        }
                        catch (NotFound e) {
                            log.warn((Object)("No account found for equivalentIdentity entry: " + equivalentIdentity.getValue()), (Throwable)e);
                            placeholderPerson = new Person();
                            placeholderPerson.setSubject(equivalentIdentity);
                            placeholderPerson.addEmail("NA");
                            placeholderPerson.addGivenName("NA");
                            placeholderPerson.setFamilyName("NA");
                            if (CNIdentityLDAPImpl.contains(pList.getPersonList(), placeholderPerson)) continue;
                            pList.addPerson(placeholderPerson);
                        }
                    }
                }
                List<Group> groups = this.lookupGroups(name);
                for (Group g : groups) {
                    person.addIsMemberOf(g.getSubject());
                    if (CNIdentityLDAPImpl.contains(pList.getGroupList(), g)) continue;
                    pList.getGroupList().add(g);
                }
                if (!CNIdentityLDAPImpl.contains(pList.getPersonList(), person)) {
                    pList.getPersonList().add(0, person);
                }
            }
        }
        return pList;
    }

    public boolean removeSubject(Subject p) {
        return super.removeEntry(p.getValue());
    }

    public boolean denyMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        try {
            Subject primarySubject = session.getSubject();
            DirContext ctx = this.getContext();
            boolean confirmationRequest = this.checkAttribute(primarySubject.getValue(), "equivalentIdentityRequest", secondarySubject.getValue());
            ModificationItem[] mods = null;
            BasicAttribute mod0 = null;
            if (!confirmationRequest) {
                throw new InvalidRequest("", "Identity mapping request has not been issued for: " + primarySubject.getValue() + " = " + secondarySubject.getValue());
            }
            mods = new ModificationItem[1];
            mod0 = new BasicAttribute("equivalentIdentityRequest", secondarySubject.getValue());
            mods[0] = new ModificationItem(3, mod0);
            ctx.modifyAttributes(primarySubject.getValue(), mods);
            log.debug((Object)("Successfully removed equivalentIdentityRequest on: " + primarySubject.getValue() + " for " + secondarySubject.getValue()));
        }
        catch (Exception e) {
            throw new ServiceFailure("2390", "Could not deny the identity mapping: " + e.getMessage());
        }
        return true;
    }

    public SubjectInfo getPendingMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        boolean redact = this.shouldRedact(session);
        if (redact) {
            if (session != null) {
                log.debug((Object)("subjectInfo requested for: '" + subject.getValue() + "'"));
                log.debug((Object)("checking if redaction holds for the calling user: '" + session.getSubject().getValue() + "'"));
            } else {
                log.debug((Object)"session is null, we will redact email");
            }
            if (session != null && session.getSubject().equals((Object)subject)) {
                log.debug((Object)("subject MATCH. lifting redaction for the calling user: '" + session.getSubject().getValue() + "'"));
                redact = false;
            }
        }
        SubjectInfo subjectInfo = new SubjectInfo();
        String dn = subject.getValue();
        try {
            DirContext ctx = this.getContext();
            Attributes attributes = ctx.getAttributes(dn);
            ArrayList<String> visitedSubjects = new ArrayList<String>();
            visitedSubjects.add(dn);
            subjectInfo = this.processAttributes(dn, attributes, true, true, redact, visitedSubjects);
            log.debug((Object)("Retrieved SubjectList for: " + dn));
        }
        catch (Exception e) {
            String msg = "Problem looking up entry: " + dn + " : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new ServiceFailure("4561", msg);
        }
        return subjectInfo;
    }

    public boolean removeMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        block5: {
            try {
                Subject primarySubject = session.getSubject();
                DirContext ctx = this.getContext();
                boolean mappingExists = this.checkAttribute(primarySubject.getValue(), "equivalentIdentity", secondarySubject.getValue());
                boolean reciprocolMappingExists = this.checkAttribute(secondarySubject.getValue(), "equivalentIdentity", primarySubject.getValue());
                ModificationItem[] mods = null;
                BasicAttribute mod0 = null;
                if (mappingExists || reciprocolMappingExists) {
                    if (mappingExists) {
                        mods = new ModificationItem[1];
                        mod0 = new BasicAttribute("equivalentIdentity", secondarySubject.getValue());
                        mods[0] = new ModificationItem(3, mod0);
                        ctx.modifyAttributes(primarySubject.getValue(), mods);
                        log.debug((Object)("Successfully removed equivalentIdentity: " + primarySubject.getValue() + " = " + secondarySubject.getValue()));
                    }
                    if (reciprocolMappingExists) {
                        mods = new ModificationItem[1];
                        mod0 = new BasicAttribute("equivalentIdentity", primarySubject.getValue());
                        mods[0] = new ModificationItem(3, mod0);
                        ctx.modifyAttributes(secondarySubject.getValue(), mods);
                        log.debug((Object)("Successfully removed reciprocal equivalentIdentity: " + secondarySubject.getValue() + " = " + primarySubject.getValue()));
                    }
                    break block5;
                }
                throw new InvalidRequest("", "There is no identity mapping between: " + primarySubject.getValue() + " and " + secondarySubject.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceFailure("2390", "Could not remove identity mapping: " + e.getMessage());
            }
        }
        return true;
    }

    private boolean shouldRedact(Session session) throws NotImplemented, ServiceFailure {
        if (session != null) {
            NodeList nodeList = null;
            try {
                nodeList = this.nodeRegistryService.listNodes();
            }
            catch (Exception e) {
                log.warn((Object)"Using D1Client to look up nodeList from CN");
                nodeList = D1Client.getCN().listNodes();
            }
            for (Node node : nodeList.getNodeList()) {
                if (!node.getType().equals((Object)NodeType.CN)) continue;
                for (Subject subject : node.getSubjectList()) {
                    if (!subject.getValue().equals(session.getSubject().getValue())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean contains(List<Person> personList, Person person) {
        for (Person p : personList) {
            if (!p.getSubject().equals((Object)person.getSubject())) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(List<Group> groupList, Group group) {
        for (Group g : groupList) {
            if (!g.getSubject().equals((Object)group.getSubject())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Subject p = new Subject();
            p.setValue("cn=testGroup2,dc=cilogon,dc=org");
            CNIdentityLDAPImpl identityService = new CNIdentityLDAPImpl();
            identityService.setServer("ldap://bespin.nceas.ucsb.edu:389");
            identityService.removeSubject(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

