/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.library;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionBase0;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.Utils;

public class SystemVar
extends FunctionBase0 {
    Symbol systemSymbol;

    protected SystemVar(Symbol systemSymbol) {
        if (systemSymbol == null) {
            throw new ExprException("System symbol is null ptr");
        }
        this.systemSymbol = systemSymbol;
    }

    public NodeValue exec() {
        Object obj = this.getContext().get(this.systemSymbol);
        if (obj == null) {
            throw new ExprEvalException("null for system symbol: " + this.systemSymbol);
        }
        if (!(obj instanceof Node)) {
            throw new ExprEvalException("Not a Node: " + Utils.className(obj));
        }
        Node n = (Node)obj;
        if (n == null) {
            throw new ExprEvalException("No value for system variable: " + this.systemSymbol);
        }
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }
}

