/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.util.FileManager;

public class ModItem
implements ArgModuleGeneral {
    protected final ArgDecl queryFileDecl = new ArgDecl(true, "file");
    private String filename = null;
    private String parseString = null;
    private Item item = null;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Item");
        cmdLine.add(this.queryFileDecl, "--file=", "File");
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.queryFileDecl)) {
            this.filename = cmdLine.getValue(this.queryFileDecl);
            this.parseString = FileManager.get().readWholeFileAsUTF8(this.filename);
            return;
        }
        if (cmdLine.getNumPositional() == 0 && this.filename == null) {
            cmdLine.cmdError("No query string or query file");
        }
        if (cmdLine.getNumPositional() > 1) {
            cmdLine.cmdError("Only one query string allowed");
        }
        if (cmdLine.getNumPositional() == 1 && this.filename != null) {
            cmdLine.cmdError("Either query string or query file - not both");
        }
        if (this.filename == null) {
            String qs = cmdLine.getPositionalArg(0);
            this.parseString = cmdLine.indirect(qs);
        }
    }

    public Item getItem() {
        if (this.item != null) {
            return this.item;
        }
        this.item = SSE.parseItem((String)this.parseString);
        return this.item;
    }
}

