/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.Iterator;

public class TestLARQUtils {
    public static QueryExecution query(Model model, String pattern) {
        return TestLARQUtils.query(model, pattern, null);
    }

    public static QueryExecution query(Model model, String pattern, IndexLARQ index) {
        String queryString = StringUtils.join((String)"\n", (String[])new String[]{"PREFIX xsd:    <http://www.w3.org/2001/XMLSchema#>", "PREFIX :       <http://example/>", "PREFIX pf:     <http://jena.hpl.hp.com/ARQ/property#>", "PREFIX  dc:    <http://purl.org/dc/elements/1.1/>", "SELECT *", pattern});
        Query query2 = QueryFactory.create((String)queryString);
        QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (Model)model);
        if (index != null) {
            LARQ.setDefaultIndex((Context)qExec.getContext(), (IndexLARQ)index);
        }
        return qExec;
    }

    public static int count(ResultSet rs) {
        return ResultSetFormatter.consume((ResultSet)rs);
    }

    public static int count(Iterator iter) {
        int count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        NiceIterator.close((Iterator)iter);
        return count;
    }

    public static IndexLARQ createIndex(String datafile, IndexBuilderModel indexBuilder) {
        return TestLARQUtils.createIndex(ModelFactory.createDefaultModel(), datafile, indexBuilder);
    }

    public static IndexLARQ createIndex(Model model, String datafile, IndexBuilderModel indexBuilder) {
        model.register((ModelChangedListener)indexBuilder);
        FileManager.get().readModel(model, datafile);
        model.unregister((ModelChangedListener)indexBuilder);
        indexBuilder.closeWriter();
        return indexBuilder.getIndex();
    }
}

