/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class DeltaInfo
implements LogWritable,
LogReadable {
    private Key key;
    private DbLsn lsn;
    private boolean knownDeleted;

    DeltaInfo(Key key, DbLsn lsn, boolean knownDeleted) {
        this.key = key;
        this.lsn = lsn;
        this.knownDeleted = knownDeleted;
    }

    DeltaInfo() {
        this.key = new Key();
        this.lsn = new DbLsn();
    }

    public int getLogSize() {
        return this.key.getLogSize() + this.lsn.getLogSize() + LogUtils.getBooleanLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.key.writeToLog(logBuffer);
        this.lsn.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.knownDeleted);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.key.readFromLog(itemBuffer);
        this.lsn.readFromLog(itemBuffer);
        this.knownDeleted = LogUtils.readBoolean(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        this.key.dumpLog(sb, verbose);
        this.lsn.dumpLog(sb, verbose);
        sb.append("<knownDeleted val=\"").append(this.knownDeleted).append("\"/>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    Key getKey() {
        return this.key;
    }

    boolean isKnownDeleted() {
        return this.knownDeleted;
    }

    DbLsn getLsn() {
        return this.lsn;
    }
}

