/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.Locker;

public class ThreadLocker
extends BasicLocker {
    private Thread thread = Thread.currentThread();

    public ThreadLocker(EnvironmentImpl env) throws DatabaseException {
        super(env);
    }

    private void checkState() throws DatabaseException {
        if (this.thread != Thread.currentThread()) {
            throw new DatabaseException("A per-thread transaction was created in " + this.thread + " but used in " + Thread.currentThread());
        }
    }

    public LockGrantType readLock(LN ln) throws DatabaseException {
        this.checkState();
        return super.readLock(ln);
    }

    public LockGrantType nonBlockingReadLock(LN ln) throws DatabaseException {
        this.checkState();
        return super.nonBlockingReadLock(ln);
    }

    public LockResult writeLock(LN ln, DatabaseImpl database) throws DatabaseException {
        this.checkState();
        return super.writeLock(ln, database);
    }

    public LockGrantType nonBlockingWriteLock(LN ln) throws DatabaseException {
        this.checkState();
        return super.nonBlockingWriteLock(ln);
    }

    public Locker newInstance() throws DatabaseException {
        this.checkState();
        return new ThreadLocker(this.envImpl);
    }

    public boolean sharesLocksWith(Locker txn) {
        try {
            ThreadLocker other = (ThreadLocker)txn;
            return this.thread == other.thread;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

