/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchTable;
import java.util.ArrayList;
import java.util.List;

public class Latch {
    private static final String DEFAULT_LATCH_NAME = "Latch";
    private static LatchTable latchTable;
    private String name = null;
    private List waiters = null;
    private LatchStats stats = new LatchStats();
    private EnvironmentImpl env = null;
    private Thread owner = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Latch(String name, EnvironmentImpl env) {
        this.name = name;
        this.env = env;
    }

    public Latch(EnvironmentImpl env) {
        this.env = env;
        this.name = DEFAULT_LATCH_NAME;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized void acquire() throws DatabaseException {
        try {
            Thread thread = Thread.currentThread();
            if (thread == this.owner) {
                ++this.stats.nAcquiresSelfOwned;
                throw new LatchException(this.getNameString() + " already held");
            }
            if (this.owner == null) {
                ++this.stats.nAcquiresNoWaiters;
                this.owner = thread;
            } else {
                if (this.waiters == null) {
                    this.waiters = new ArrayList();
                }
                this.waiters.add(thread);
                ++this.stats.nAcquiresWithContention;
                while (thread != this.owner) {
                    this.wait();
                }
            }
            if (!$assertionsDisabled && !this.noteLatch()) {
                throw new AssertionError();
            }
        }
        catch (InterruptedException e) {
            throw new RunRecoveryException(this.env, (Throwable)e);
        }
        finally {
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean acquireNoWait() throws LatchException {
        try {
            Thread thread = Thread.currentThread();
            if (thread == this.owner) {
                ++this.stats.nAcquiresSelfOwned;
                throw new LatchException(this.getNameString() + " already held");
            }
            if (this.owner == null) {
                this.owner = thread;
                ++this.stats.nAcquireNoWaitSuccessful;
                if (!$assertionsDisabled && !this.noteLatch()) {
                    throw new AssertionError();
                }
                boolean bl = true;
                return bl;
            }
            ++this.stats.nAcquireNoWaitUnsuccessful;
            boolean bl = false;
            return bl;
        }
        finally {
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws LatchNotHeldException {
        try {
            Thread thread = Thread.currentThread();
            if (thread != this.owner) {
                throw new LatchNotHeldException(this.getNameString() + " not held");
            }
            if (this.waiters != null && this.waiters.size() > 0) {
                this.owner = (Thread)this.waiters.remove(0);
                this.notifyAll();
            } else {
                this.owner = null;
            }
            ++this.stats.nReleases;
            if (!$assertionsDisabled && !this.unNoteLatch()) {
                throw new AssertionError();
            }
        }
        finally {
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
        }
    }

    public boolean isOwner() {
        return Thread.currentThread() == this.owner;
    }

    public Thread owner() {
        return this.owner;
    }

    synchronized int nWaiters() {
        return this.waiters != null ? this.waiters.size() : 0;
    }

    public LatchStats getLatchStats() {
        LatchStats s = null;
        try {
            s = (LatchStats)this.stats.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return s;
    }

    public synchronized String toString() {
        return latchTable.toString(this.name, this.owner, this.waiters, 0);
    }

    private String getNameString() {
        return latchTable.getNameString(this.name);
    }

    private boolean noteLatch() throws LatchException {
        return latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() throws LatchNotHeldException {
        return latchTable.unNoteLatch(this, this.name);
    }

    public static int countLatchesHeld() {
        return latchTable.countLatchesHeld();
    }

    public static void dumpLatchesHeld() {
        System.out.println(Latch.latchesHeldToString());
    }

    public static String latchesHeldToString() {
        return latchTable.latchesHeldToString();
    }

    public static void clearNotes() {
        latchTable.clearNotes();
    }

    static {
        $assertionsDisabled = !Latch.class.desiredAssertionStatus();
        latchTable = new LatchTable(DEFAULT_LATCH_NAME);
    }
}

