/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.ModelAssembler;
import com.hp.hpl.jena.assembler.test.TestModelContent;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.util.List;

final class MockTransactionModel
extends ModelAssembler {
    private final List history;
    private final Model expected;
    private final boolean supportsTransactions;
    private final boolean abortsOnAdd;

    protected MockTransactionModel(List history, Model expected, boolean supportsTransactions, boolean abortsOnAdd) {
        this.history = history;
        this.expected = expected;
        this.supportsTransactions = supportsTransactions;
        this.abortsOnAdd = abortsOnAdd;
    }

    protected Model openEmptyModel(Assembler a, Resource root, Mode irrelevant) {
        return new ModelCom(Factory.createDefaultGraph()){

            public Model begin() {
                MockTransactionModel.this.history.add("begin");
                TestModelContent.assertTrue((boolean)this.isEmpty());
                return this;
            }

            public Model add(Model other) {
                MockTransactionModel.this.history.add("add");
                if (MockTransactionModel.this.abortsOnAdd) {
                    throw new RuntimeException("model aborts on add of " + other);
                }
                super.add(other);
                return this;
            }

            public Model abort() {
                MockTransactionModel.this.history.add("abort");
                return this;
            }

            public Model commit() {
                TestModelContent.assertIsoModels(MockTransactionModel.this.expected, (Model)this);
                MockTransactionModel.this.history.add("commit");
                return this;
            }

            public boolean supportsTransactions() {
                MockTransactionModel.this.history.add("supports[" + MockTransactionModel.this.supportsTransactions + "]");
                return MockTransactionModel.this.supportsTransactions;
            }
        };
    }
}

