/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractTestGraphMaker
extends GraphTestBase {
    private GraphMaker gf;

    public AbstractTestGraphMaker(String name) {
        super(name);
    }

    public abstract GraphMaker getGraphMaker();

    public void setUp() {
        this.gf = this.getGraphMaker();
    }

    public void tearDown() {
        this.gf.close();
    }

    public void testGetGraph() {
        Graph g1 = this.gf.getGraph();
        AbstractTestGraphMaker.assertFalse((String)"should deliver a Graph", (g1 == null ? 1 : 0) != 0);
        AbstractTestGraphMaker.assertSame((Object)g1, (Object)this.gf.getGraph());
        g1.close();
    }

    public void testCreateGraph() {
        AbstractTestGraphMaker.assertDiffer("each created graph must differ", this.gf.createGraph(), this.gf.createGraph());
    }

    public void testAnyName() {
        this.gf.createGraph("plain").close();
        this.gf.createGraph("with.dot").close();
        this.gf.createGraph("http://electric-hedgehog.net/topic#marker").close();
    }

    public void testCannotCreateTwice() {
        String name = this.jName("bonsai");
        this.gf.createGraph(name, true);
        try {
            this.gf.createGraph(name, true);
            AbstractTestGraphMaker.fail((String)("should not be able to create " + name + " twice"));
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    private String jName(String name) {
        return "jena-test-AbstractTestGraphMaker-" + name;
    }

    public void testCanCreateTwice() {
        String name = this.jName("bridge");
        Graph g1 = this.gf.createGraph(name, true);
        Graph g2 = this.gf.createGraph(name, false);
        AbstractTestGraphMaker.assertTrue((String)"graphs should be the same", (boolean)this.sameGraph(g1, g2));
        Graph g3 = this.gf.createGraph(name);
        AbstractTestGraphMaker.assertTrue((String)"graphs should be the same", (boolean)this.sameGraph(g1, g3));
    }

    public void testCannotOpenUncreated() {
        String name = this.jName("noSuchGraph");
        try {
            this.gf.openGraph(name, true);
            AbstractTestGraphMaker.fail((String)(name + " should not exist"));
        }
        catch (DoesNotExistException doesNotExistException) {
            // empty catch block
        }
    }

    public void testCanOpenUncreated() {
        String name = this.jName("willBeCreated");
        Graph g1 = this.gf.openGraph(name);
        g1.close();
        this.gf.openGraph(name, true);
    }

    private void testExists(String name) {
        AbstractTestGraphMaker.assertTrue((String)(name + " should exist"), (boolean)this.gf.hasGraph(name));
    }

    private void testDoesNotExist(String name) {
        AbstractTestGraphMaker.assertFalse((String)(name + " should exist"), (boolean)this.gf.hasGraph(name));
    }

    public void testCanFindCreatedGraph() {
        String alpha = this.jName("alpha");
        String beta = this.jName("beta");
        Graph g1 = this.gf.createGraph(alpha, true);
        Graph h1 = this.gf.createGraph(beta, true);
        Graph g2 = this.gf.openGraph(alpha, true);
        Graph h2 = this.gf.openGraph(beta, true);
        AbstractTestGraphMaker.assertTrue((String)"should find alpha", (boolean)this.sameGraph(g1, g2));
        AbstractTestGraphMaker.assertTrue((String)"should find beta", (boolean)this.sameGraph(h1, h2));
    }

    private boolean sameGraph(Graph g1, Graph g2) {
        Node S = AbstractTestGraphMaker.node("S");
        Node P = AbstractTestGraphMaker.node("P");
        Node O = AbstractTestGraphMaker.node("O");
        g1.add(Triple.create((Node)S, (Node)P, (Node)O));
        g2.add(Triple.create((Node)O, (Node)P, (Node)S));
        return g2.contains(S, P, O) && g1.contains(O, P, S);
    }

    public void testCanRemoveGraph() {
        String alpha = this.jName("bingo");
        String beta = this.jName("brillo");
        this.gf.createGraph(alpha, true);
        this.gf.createGraph(beta, true);
        this.testExists(alpha);
        this.testExists(beta);
        this.gf.removeGraph(alpha);
        this.testExists(beta);
        this.testDoesNotExist(alpha);
    }

    public void testHasnt() {
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
        this.gf.createGraph("john", true);
        AbstractTestGraphMaker.assertTrue((String)"john now exists", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
        this.gf.createGraph("paul", true);
        AbstractTestGraphMaker.assertTrue((String)"john still exists", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertTrue((String)"paul now exists", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
        this.gf.removeGraph("john");
        AbstractTestGraphMaker.assertFalse((String)"john has been removed", (boolean)this.gf.hasGraph("john"));
        AbstractTestGraphMaker.assertTrue((String)"paul still exists", (boolean)this.gf.hasGraph("paul"));
        AbstractTestGraphMaker.assertFalse((String)"no such graph", (boolean)this.gf.hasGraph("george"));
    }

    public void testCarefulClose() {
        Graph x = this.gf.createGraph("x");
        Graph y = this.gf.openGraph("x");
        x.add(AbstractTestGraphMaker.triple("a BB c"));
        x.close();
        y.add(AbstractTestGraphMaker.triple("p RR q"));
        y.close();
    }

    public void testListNoGraphs() {
        Set s = AbstractTestGraphMaker.iteratorToSet((Iterator)this.gf.listGraphs());
        if (s.size() > 0) {
            AbstractTestGraphMaker.fail((String)("found names from 'empty' graph maker: " + s));
        }
    }

    public void testListThreeGraphs() {
        String x = "x";
        String y = "y/sub";
        String z = "z:boo";
        Graph X = this.gf.createGraph(x);
        Graph Y = this.gf.createGraph(y);
        Graph Z = this.gf.createGraph(z);
        Set wanted = AbstractTestGraphMaker.setOfStrings(x + " " + y + " " + z);
        AbstractTestGraphMaker.assertEquals((Object)wanted, (Object)AbstractTestGraphMaker.iteratorToSet((Iterator)this.gf.listGraphs()));
        X.close();
        Y.close();
        Z.close();
    }

    public void testListAfterDelete() {
        String x = "x_y";
        String y = "y//zub";
        String z = "a:b/c";
        Graph X = this.gf.createGraph(x);
        Graph Y = this.gf.createGraph(y);
        Graph Z = this.gf.createGraph(z);
        this.gf.removeGraph(x);
        Set s = AbstractTestGraphMaker.iteratorToSet((Iterator)this.gf.listGraphs());
        AbstractTestGraphMaker.assertEquals((Object)AbstractTestGraphMaker.setOfStrings(y + " " + z), (Object)s);
        X.close();
        Y.close();
        Z.close();
    }
}

