/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestReificationPredicates
extends GraphTestBase {
    public TestReificationPredicates(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestReificationPredicates.class);
    }

    public void testSubject() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationPredicate((Node)RDF.Nodes.subject));
    }

    public void testPredicate() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationPredicate((Node)RDF.Nodes.predicate));
    }

    public void testObject() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationPredicate((Node)RDF.Nodes.object));
    }

    public void testRest() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate((Node)RDF.Nodes.rest));
    }

    public void testFirst() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate((Node)RDF.Nodes.first));
    }

    public void testType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate((Node)RDF.Nodes.type));
    }

    public void testValue() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate((Node)RDF.Nodes.value));
    }

    public void testSubjectInOtherNamespace() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate((Node)TestReificationPredicates.node("subject")));
    }

    public void testStatementCouldBeStatement() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.couldBeStatement((Node)RDF.Nodes.Statement));
    }

    public void testVariableCouldBeStatement() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.couldBeStatement((Node)TestReificationPredicates.node("?x")));
    }

    public void testANYCouldBeStatement() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.couldBeStatement((Node)Node.ANY));
    }

    public void testPropertyCouldNotBeStatement() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.couldBeStatement((Node)RDF.Nodes.Property));
    }

    public void testOtherStatementCouldBeStatement() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.couldBeStatement((Node)TestReificationPredicates.node("Statement")));
    }

    public void testAltIsntIsReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.type, (Node)RDF.Nodes.Alt));
    }

    public void testBagIsntIsReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.type, (Node)RDF.Nodes.Bag));
    }

    public void testOtherStatementIsntIsReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.type, (Node)TestReificationPredicates.node("Statement")));
    }

    public void testValueIsNtReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.value, (Node)RDF.Nodes.Statement));
    }

    public void testValuePropertyIsntreificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.value, (Node)RDF.Nodes.Property));
    }

    public void testStatementIsReificationType() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.type, (Node)RDF.Nodes.Statement));
    }

    public void testVariableIsReificationType() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.type, (Node)TestReificationPredicates.node("?x")));
    }

    public void testANYIsReificationType() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationType((Node)RDF.Nodes.type, (Node)Node.ANY));
    }
}

