/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.test.TestXMLAbbrev;
import com.hp.hpl.jena.xmloutput.test.TestXMLFeatures;
import com.hp.hpl.jena.xmloutput.test.testWriterInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class testWriterAndReader
extends ModelTestBase
implements RDFErrorHandler {
    private static boolean showProgress = false;
    private static int firstTest = 4;
    private static int lastTest = 9;
    private static int repetitionsJ = 6;
    protected static Log logger = LogFactory.getLog((Class)testWriterAndReader.class);
    final String lang;
    final int fileNumber;
    final int options;
    String test;
    static Resource[] blockRules = new Resource[]{RDFSyntax.parseTypeLiteralPropertyElt, RDFSyntax.parseTypeCollectionPropertyElt, RDFSyntax.propertyAttr, RDFSyntax.sectionReification, RDFSyntax.sectionListExpand, RDFSyntax.parseTypeResourcePropertyElt, DAML_OIL.collection};
    static final String[] baseUris = new String[]{"http://foo.com/Hello", "http://foo.com/Hello", "http://daml.umbc.edu/ontologies/calendar-ont", "http://www.daml.org/2001/03/daml+oil-ex"};
    ByteArrayOutputStream tmpOut;
    static boolean linuxFileDeleteErrorFlag = false;

    testWriterAndReader(String name, String lang, int fileNumber) {
        this(name, lang, fileNumber, 0);
    }

    testWriterAndReader(String name, String lang, int fileNumber, int options) {
        super(name);
        this.lang = lang;
        this.fileNumber = fileNumber;
        this.options = options;
    }

    public String toString() {
        return this.getName() + " " + this.lang + " t" + this.fileNumber + "000.rdf" + (this.options != 0 ? "[" + this.options + "]" : "");
    }

    static Test suiteN_TRIPLE() {
        return testWriterAndReader.baseSuite("N-TRIPLE");
    }

    static TestSuite suiteXML() {
        TestSuite baseTests = testWriterAndReader.baseSuite("RDF/XML");
        baseTests.addTestSuite(TestXMLFeatures_XML.class);
        baseTests.addTest((Test)testWriterAndReader.addXMLtests("RDF/XML", false));
        return baseTests;
    }

    static Test suiteXML_ABBREV() {
        TestSuite suite = testWriterAndReader.baseSuite("RDF/XML-ABBREV");
        suite.addTestSuite(TestXMLFeatures_XML_ABBREV.class);
        suite.addTestSuite(TestXMLAbbrev.class);
        suite.addTest((Test)testWriterAndReader.addXMLtests("RDF/XML-ABBREV", false));
        return suite;
    }

    public static TestSuite repeatedAbbrevSuite() {
        TestSuite suite = testWriterAndReader.baseSuite("RDF/XML-ABBREV");
        suite.addTestSuite(TestXMLFeatures_XML_ABBREV.class);
        suite.addTestSuite(TestXMLAbbrev.class);
        suite.addTest((Test)testWriterAndReader.addXMLtests("RDF/XML-ABBREV", true));
        return suite;
    }

    static TestSuite baseSuite(String lang) {
        TestSuite langsuite = new TestSuite();
        langsuite.setName(lang);
        langsuite.addTest((Test)new testWriterInterface("testWriting", lang));
        langsuite.addTest((Test)new testWriterInterface("testLineSeparator", lang));
        return langsuite;
    }

    private static boolean nBits(int i, int[] ok) {
        int bitCount = 0;
        while (i > 0) {
            if ((i & 1) == 1) {
                ++bitCount;
            }
            i >>= 1;
        }
        for (int j = 0; j < ok.length; ++j) {
            if (bitCount != ok[j]) continue;
            return true;
        }
        return false;
    }

    private static TestSuite addXMLtests(String lang, boolean lots) {
        TestSuite suite = new TestSuite();
        int optionLimit = lang.equals("RDF/XML-ABBREV") ? 1 << blockRules.length : 2;
        for (int fileNumber = firstTest; fileNumber <= lastTest; ++fileNumber) {
            suite.addTest((Test)new testWriterAndReader("testRandom", lang, fileNumber));
            suite.addTest((Test)new testWriterAndReader("testLongId", lang, fileNumber));
            for (int optionMask = 1; optionMask < optionLimit; ++optionMask) {
                if (!lots && !testWriterAndReader.nBits(optionMask, new int[]{1, 6, 7})) continue;
                suite.addTest((Test)testWriterAndReader.createTestOptions(lang, fileNumber, optionMask));
            }
        }
        return suite;
    }

    private static testWriterAndReader createTestOptions(String lang, int fileNumber, int optionMask) {
        return new testWriterAndReader("testOptions " + fileNumber + " " + optionMask, lang, fileNumber, optionMask){

            public void runTest() throws IOException {
                this.testOptions();
            }
        };
    }

    public void testRandom() throws IOException {
        this.doTest(new String[0], new Object[0]);
    }

    public void testLongId() throws IOException {
        this.doTest(new String[]{"longId"}, new Object[]{Boolean.TRUE});
    }

    public void testOptions() throws IOException {
        Vector<Resource> v = new Vector<Resource>();
        for (int i = 0; i < blockRules.length; ++i) {
            if ((this.options & 1 << i) == 0) continue;
            v.add(blockRules[i]);
        }
        Object[] blocked = new Resource[v.size()];
        v.copyInto(blocked);
        this.doTest(new String[]{"blockRules"}, (Object[])new Resource[][]{blocked});
    }

    public void doTest(String[] propNames, Object[] propVals) throws IOException {
        this.test(this.lang, 35, 1, propNames, propVals);
    }

    public void test(String rwLang, int seed, int variationMax, String[] wopName, Object[] wopVal) throws IOException {
        Model m1 = testWriterAndReader.createMemModel();
        this.test = "testWriterAndReader lang=" + rwLang + " seed=" + seed;
        String filebase = "testing/regression/testWriterAndReader/";
        if (showProgress) {
            System.out.println("Beginning " + this.test);
        }
        Random random = new Random(seed);
        RDFReader rdfRdr = m1.getReader(rwLang);
        RDFWriter rdfWtr = m1.getWriter(rwLang);
        this.setWriterOptionsAndHandlers(wopName, wopVal, rdfRdr, rdfWtr);
        for (int variationIndex = 0; variationIndex < variationMax; ++variationIndex) {
            this.testVariation(filebase, random, rdfRdr, rdfWtr);
        }
        if (showProgress) {
            System.out.println("End of " + this.test);
        }
    }

    private void setWriterOptionsAndHandlers(String[] wopName, Object[] wopVal, RDFReader rdfRdr, RDFWriter rdfWtr) {
        rdfRdr.setErrorHandler((RDFErrorHandler)this);
        rdfWtr.setErrorHandler((RDFErrorHandler)this);
        if (wopName != null) {
            for (int i = 0; i < wopName.length; ++i) {
                rdfWtr.setProperty(wopName[i], wopVal[i]);
            }
        }
    }

    private void testVariation(String filebase, Random random, RDFReader rdfRdr, RDFWriter rdfWtr) throws FileNotFoundException, IOException {
        Model m1 = testWriterAndReader.createMemModel();
        String fileName = "t" + this.fileNumber * 1000 + ".rdf";
        String baseUriRead = this.fileNumber < baseUris.length ? baseUris[this.fileNumber] : "http://foo.com/Hello";
        FileInputStream rdr = new FileInputStream(filebase + fileName);
        m1.read((InputStream)rdr, baseUriRead);
        ((InputStream)rdr).close();
        for (int j = 0; j < repetitionsJ; ++j) {
            String baseUriWrite = j % 2 == 0 ? baseUriRead : "http://bar.com/irrelevant";
            int cn = (int)m1.size();
            if (j % 2 == 0 && j > 0) {
                this.prune(m1, random, 1 + cn / 10);
            }
            if (j % 2 == 0 && j > 0) {
                this.expand(m1, random, 1 + cn / 10);
            }
            this.tmpOut = new ByteArrayOutputStream();
            rdfWtr.write(m1, (OutputStream)this.tmpOut, baseUriWrite);
            this.tmpOut.flush();
            this.tmpOut.close();
            Model m2 = testWriterAndReader.createMemModel();
            ByteArrayInputStream in = new ByteArrayInputStream(this.tmpOut.toByteArray());
            rdfRdr.read(m2, (InputStream)in, baseUriWrite);
            ((InputStream)in).close();
            Model s1 = m1;
            Model s2 = m2;
            testWriterAndReader.assertIsoModels("Comparison of file written out, and file read in.", s1, s2);
            this.tmpOut.reset();
            this.tmpOut = null;
        }
        if (showProgress) {
            System.out.print("+");
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune(Model m, Random random, int count) {
        int i;
        Statement[] toRemove = new Statement[count];
        int sz = (int)m.size();
        StmtIterator ss = m.listStatements();
        try {
            for (i = 0; i < count; ++i) {
                toRemove[i] = ss.nextStatement();
            }
            while (ss.hasNext()) {
                int ix = random.nextInt(sz);
                if (ix >= count) continue;
                toRemove[ix] = ss.nextStatement();
            }
        }
        finally {
            ss.close();
        }
        for (i = 0; i < count; ++i) {
            m.remove(toRemove[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(Model m, Random random, int count) {
        int i;
        Resource[] subject = new Resource[count];
        Property[] predicate = new Property[count];
        RDFNode[] object = new RDFNode[count];
        int sz = (int)m.size();
        StmtIterator ss = m.listStatements();
        try {
            for (i = 0; i < count; ++i) {
                Statement s = ss.nextStatement();
                subject[i] = s.getSubject();
                predicate[i] = s.getPredicate();
                object[i] = s.getObject();
            }
            while (ss.hasNext()) {
                Statement s = ss.nextStatement();
                Resource subj = s.getSubject();
                RDFNode obj = s.getObject();
                int ix = random.nextInt(sz);
                if (ix < count) {
                    subject[ix] = subj;
                }
                if ((ix = random.nextInt(sz)) < count) {
                    object[ix] = subj;
                }
                if ((ix = random.nextInt(sz)) < count) {
                    predicate[ix] = s.getPredicate();
                }
                if ((ix = random.nextInt(sz)) < count) {
                    object[ix] = obj;
                }
                if (!(obj instanceof Resource) || (ix = random.nextInt(sz)) >= count) continue;
                subject[ix] = (Resource)obj;
            }
        }
        finally {
            ss.close();
        }
        for (i = 0; i < count; ++i) {
            m.add(subject[i], predicate[i], object[i]);
        }
    }

    public void warning(Exception e) {
        System.out.println(new String(this.tmpOut.toString()));
        throw new JenaException((Throwable)e);
    }

    public void error(Exception e) {
        testWriterAndReader.fail((String)e.getMessage());
    }

    public void fatalError(Exception e) {
        this.error(e);
        throw new JenaException((Throwable)e);
    }

    public static class TestXMLFeatures_XML_ABBREV
    extends TestXMLFeatures {
        public TestXMLFeatures_XML_ABBREV(String name) {
            super(name, "RDF/XML-ABBREV");
        }
    }

    public static class TestXMLFeatures_XML
    extends TestXMLFeatures {
        public TestXMLFeatures_XML(String name) {
            super(name, "RDF/XML");
        }
    }
}

