/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.context;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.StringManager;

public class LoadOnStartupInterceptor
extends BaseInterceptor {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.resources");

    public void contextInit(Context ctx) {
        Hashtable loadableServlets = new Hashtable();
        this.init(ctx, loadableServlets);
        Vector<Integer> orderedKeys = new Vector<Integer>();
        Enumeration e = loadableServlets.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            int slot = -1;
            int i = 0;
            while (i < orderedKeys.size()) {
                if (key < (Integer)orderedKeys.elementAt(i)) {
                    slot = i;
                    break;
                }
                ++i;
            }
            if (slot > -1) {
                orderedKeys.insertElementAt(key, slot);
                continue;
            }
            orderedKeys.addElement(key);
        }
        int i = 0;
        while (i < orderedKeys.size()) {
            Integer key = (Integer)orderedKeys.elementAt(i);
            Enumeration sOnLevel = ((Vector)loadableServlets.get(key)).elements();
            while (sOnLevel.hasMoreElements()) {
                String servletName = (String)sOnLevel.nextElement();
                ServletWrapper result = ctx.getServletByName(servletName);
                if (ctx.getDebug() > 0) {
                    ctx.log("Loading " + key + " " + servletName);
                }
                if (result == null) {
                    System.out.println("Warning: we try to load an undefined servlet " + servletName);
                    continue;
                }
                try {
                    if (result.getPath() != null) {
                        this.loadJsp(ctx, result);
                        continue;
                    }
                    result.init();
                }
                catch (Exception ee) {
                    String msg = sm.getString("context.loadServlet.e", servletName);
                    System.out.println(String.valueOf(msg) + ": " + ee.getMessage());
                }
            }
            ++i;
        }
    }

    void init(Context ctx, Hashtable loadableServlets) {
        Enumeration enumeration = ctx.getServletNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            ServletWrapper sw = ctx.getServletByName(name);
            if (!sw.getLoadOnStartUp()) continue;
            Integer level = new Integer(sw.getLoadOnStartUpLevel());
            Vector v = loadableServlets.get(level) != null ? (Vector)loadableServlets.get(level) : new Vector();
            v.addElement(name);
            loadableServlets.put(level, v);
        }
    }

    void loadJsp(Context context, ServletWrapper result) throws Exception {
        System.out.println("Initializing JSP with JspWrapper");
        ContextManager cm = context.getContextManager();
        String path = result.getPath();
        RequestImpl request = new RequestImpl();
        ResponseImpl response = new ResponseImpl();
        request.setContextManager(cm);
        request.recycle();
        response.recycle();
        request.setResponse(response);
        response.setRequest(request);
        String requestURI = String.valueOf(path) + "?jsp_precompile=true";
        request.setRequestURI(String.valueOf(context.getPath()) + path);
        request.setQueryString("jsp_precompile=true");
        request.setContext(context);
        cm.service(request, response);
    }
}

