/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.facade.ServletOutputStreamFacade;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.StringManager;

final class HttpServletResponseFacade
implements HttpServletResponse {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Response response;
    private boolean usingStream = false;
    private boolean usingWriter = false;
    ServletOutputStreamFacade osFacade = null;
    PrintWriter writer = null;

    HttpServletResponseFacade(Response response) {
        this.response = response;
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public void addDateHeader(String name, long value) {
        MimeHeaders headers = this.response.getMimeHeaders();
        MimeHeaderField headerF = headers.putHeader();
        headerF.setName(name);
        headerF.setDateValue(value);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.response.addHeader(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeRedirectURL(String location) {
        if (this.isEncodeable(this.toAbsolute(location))) {
            return this.toEncoded(location, this.response.getRequest().getSession(false));
        }
        return location;
    }

    public String encodeRedirectUrl(String location) {
        return this.encodeRedirectURL(location);
    }

    public String encodeURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.response.getRequest().getSession(false));
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public ServletOutputStream getOutputStream() {
        if (this.usingWriter) {
            String msg = sm.getString("serverResponse.outputStream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        this.response.setUsingStream(true);
        if (this.osFacade != null) {
            return this.osFacade;
        }
        if (this.response.getOutputBuffer() != null) {
            this.osFacade = new ServletOutputStreamFacade(this.response);
            return this.osFacade;
        }
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingStream) {
            String msg = sm.getString("serverResponse.writer.ise");
            throw new IllegalStateException(msg);
        }
        this.usingWriter = true;
        this.response.setUsingWriter(true);
        if (this.osFacade == null && this.response.getOutputBuffer() == null) {
            return this.response.getWriter();
        }
        if (this.osFacade == null) {
            this.osFacade = new ServletOutputStreamFacade(this.response);
        }
        if (this.writer != null) {
            return this.writer;
        }
        this.writer = ((ResponseImpl)this.response).getWriter(this.osFacade);
        return this.writer;
    }

    public boolean isCommitted() {
        return this.response.isBufferCommitted();
    }

    private boolean isEncodeable(String location) {
        String file;
        if (location.startsWith("#")) {
            return false;
        }
        Request request = this.response.getRequest();
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        if (!session.isNew() && request.getFacade().isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        if (!request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int urlPort = url.getPort();
        if (urlPort == -1) {
            urlPort = request.isSecure() ? 443 : 80;
        }
        if (request.getServerPort() != urlPort) {
            return false;
        }
        String contextPath = request.getContext().getPath();
        return contextPath == null || contextPath.length() <= 0 || (file = url.getFile()) != null && file.startsWith(contextPath);
    }

    void recycle() {
        this.usingStream = false;
        this.usingWriter = false;
        this.writer = null;
        if (this.osFacade != null) {
            this.osFacade.recycle();
        }
    }

    public void reset() throws IllegalStateException {
        this.response.reset();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "No detailed message");
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            Context ctx = this.response.getRequest().getContext();
            ctx.log("Servlet API error: sendError with commited buffer ");
            throw new IllegalStateException(sm.getString("hsrf.error.ise"));
        }
        this.setStatus(sc);
        Request request = this.response.getRequest();
        request.setAttribute("javax.servlet.error.message", msg);
        ContextManager cm = request.getContextManager();
        cm.handleStatus(request, this.response, sc);
    }

    public void sendRedirect(String location) throws IOException, IllegalArgumentException {
        if (location == null) {
            String msg = sm.getString("hsrf.redirect.iae");
            throw new IllegalArgumentException(msg);
        }
        this.sendError(302, this.toAbsolute(location));
    }

    public void setBufferSize(int size) throws IllegalStateException {
        this.response.setBufferSize(size);
    }

    public void setContentLength(int len) {
        this.response.setContentLength(len);
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public void setDateHeader(String name, long date) {
        MimeHeaders headers = this.response.getMimeHeaders();
        MimeHeaderField headerF = headers.find(name);
        if (headerF == null) {
            headerF = headers.putHeader();
        }
        headerF.setName(name);
        headerF.setDateValue(date);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setHeader(name, Integer.toString(value));
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void setStatus(int sc, String msg) {
        this.response.setStatus(sc);
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            Request request = this.response.getRequest();
            String requrl = HttpUtils.getRequestURL((HttpServletRequest)request.getFacade()).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException malformedURLException2) {
                return location;
            }
        }
        return url.toString();
    }

    private String toEncoded(String url, HttpSession session) {
        if (url == null || session == null) {
            return url;
        }
        String sessionId = session.getId();
        String path = null;
        String everythingElse = null;
        int pathEnd = url.indexOf("?");
        if (pathEnd < 0) {
            pathEnd = url.indexOf("#");
        }
        if (pathEnd < 0) {
            path = url;
        } else {
            path = url.substring(0, pathEnd);
            everythingElse = url.substring(pathEnd);
        }
        StringBuffer sb = new StringBuffer(path);
        sb.append(";jsessionid=");
        sb.append(sessionId);
        if (everythingElse != null) {
            sb.append(everythingElse);
        }
        return sb.toString();
    }
}

