/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServletWrapper;

class FormAuthHandler
extends ServletWrapper {
    FormAuthHandler() {
        this.initialized = true;
        this.internal = true;
        this.name = "tomcat.formAuthHandler";
    }

    public void doService(Request req, Response res) throws Exception {
        Context ctx = req.getContext();
        HttpSession session = req.getSession(false);
        String page = ctx.getFormLoginPage();
        String errorPage = ctx.getFormErrorPage();
        session = req.getSession(true);
        String username = (String)session.getAttribute("j_username");
        if (this.debug > 0) {
            this.log("Username = " + username);
        }
        if (username != null) {
            session.removeAttribute("j_username");
            session.removeAttribute("j_password");
            req.setAttribute("javax.servlet.error.message", errorPage);
            this.contextM.handleStatus(req, res, 302);
            return;
        }
        String originalLocation = req.getRequestURI();
        if (req.getQueryString() != null) {
            originalLocation = String.valueOf(originalLocation) + "?" + req.getQueryString();
        }
        session.setAttribute("tomcat.auth.originalLocation", (Object)originalLocation);
        if (this.debug > 0) {
            this.log("Redirect1: " + page + " originalUri=" + req.getRequestURI());
        }
        req.setAttribute("javax.servlet.error.message", page);
        this.contextM.handleStatus(req, res, 302);
    }
}

