/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.daemon;

import com.hazelcast.core.Hazelcast;
import java.util.Collection;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.auditor.v1.ScheduledReplicationAuditController;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SchedulerDaemon
implements Daemon {
    private String appContextLocation = "file:/etc/dataone/process/applicationContext.xml";
    private ApplicationContext context;
    static final String localCnIdentifier = Settings.getConfiguration().getString("cn.nodeId");
    private static final String SCHEDULED_REPLICA_AUDIT_NAME = "scheduledReplicationAuditController";
    private ScheduledReplicationAuditController replicationAuditScheduler;

    public SchedulerDaemon() {
        System.out.println("ServiceDaemon: instance " + this.hashCode() + " created");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        System.out.println("ServiceDaemon: instance " + this.hashCode() + " garbage collected");
    }

    public void init(DaemonContext context) throws Exception {
        System.out.println("ServiceDaemon: instance " + this.hashCode() + " init");
        System.out.println("ServiceDaemon: init done ");
    }

    public void start() {
        System.out.println("ServiceDaemon: starting");
        this.context = new FileSystemXmlApplicationContext(this.appContextLocation);
        this.startScheduledReplicationAuditing();
        System.out.println("ServiceDaemon: started");
    }

    public void stop() {
        System.out.println("ServiceDaemon: stopping");
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            Collection quartzSchedulers = schedulerFactory.getAllSchedulers();
            int numOfSchedulers = quartzSchedulers.size();
            System.out.println("Found " + numOfSchedulers + " Quartz schedulers");
            Scheduler[] schedulers = new Scheduler[numOfSchedulers];
            schedulers = quartzSchedulers.toArray(schedulers);
            for (int i = 0; i < numOfSchedulers; ++i) {
                if (schedulers[i].isShutdown()) continue;
                System.out.println("Stopping Quartz scheduler " + schedulers[i].getSchedulerName());
                schedulers[i].shutdown(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Shutting down Quartz scheduler failed: ");
        }
        Hazelcast.shutdownAll();
        this.stopScheduledReplicationAuditing();
        System.out.println("ServiceDaemon: stopped");
    }

    private void stopScheduledReplicationAuditing() {
        if (this.replicationAuditScheduler != null) {
            System.out.println("Stopping replication audit scheduler....");
            this.replicationAuditScheduler.shutdown();
        }
    }

    private void startScheduledReplicationAuditing() {
        try {
            this.replicationAuditScheduler = (ScheduledReplicationAuditController)this.context.getBean(SCHEDULED_REPLICA_AUDIT_NAME);
            this.replicationAuditScheduler.startup();
        }
        catch (Exception e) {
            System.out.println("ServiceDaemon: unable to start Replication Audit Scheduler.");
            e.printStackTrace();
        }
    }

    public void destroy() {
        System.out.println("ServiceDaemon: instance " + this.hashCode() + " destroy");
    }
}

