/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright 2012. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package org.dataone.cn.data.repository;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface ReplicationAttemptHistoryRepository extends
        PagingAndSortingRepository<ReplicationAttemptHistory, Long> {

    List<ReplicationAttemptHistory> findByPid(String pidValue);

    List<ReplicationAttemptHistory> findByNodeId(String nodeId);

    List<ReplicationAttemptHistory> findByPidAndNodeId(String pidValue, String nodeId);

    List<ReplicationAttemptHistory> findByReplicationAttempts(Integer attempts);

    Page<ReplicationAttemptHistory> findByPid(String pidValue, Pageable page);
}
