/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.data.repository.ReplicationTask;
import org.dataone.cn.data.repository.ReplicationTaskRepository;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v2.SystemMetadata;

public class ReplicationEventListener
implements EntryListener<Identifier, SystemMetadata> {
    private static Logger log = Logger.getLogger(ReplicationEventListener.class);
    private HazelcastClient hzClient = HazelcastClientFactory.getStorageClient();
    private static final String systemMetadataMap = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
    private IMap<Identifier, SystemMetadata> systemMetadata = this.hzClient.getMap(systemMetadataMap);
    private ReplicationTaskRepository replicationTaskRepository;

    public ReplicationEventListener() {
        this.systemMetadata.addEntryListener((EntryListener)this, true);
        log.info((Object)("Added a listener to the " + this.systemMetadata.getName() + " map."));
        this.replicationTaskRepository = ReplicationFactory.getReplicationTaskRepository();
        ReplicationFactory.getReplicationManager();
    }

    public void init() {
        log.info((Object)"initialization");
    }

    public void entryAdded(EntryEvent<Identifier, SystemMetadata> event) {
        if (ComponentActivationUtility.replicationIsActive()) {
            log.info((Object)("Received entry added event on the hzSystemMetadata map for pid: " + ((Identifier)event.getKey()).getValue()));
            if (this.isAuthoritativeReplicaValid((SystemMetadata)event.getValue())) {
                this.createReplicationTask((Identifier)event.getKey());
            } else {
                log.info((Object)("Authoritative replica is not valid, not queueing to replication for pid: " + ((Identifier)event.getKey()).getValue()));
            }
        }
    }

    public void entryUpdated(EntryEvent<Identifier, SystemMetadata> event) {
        if (ComponentActivationUtility.replicationIsActive()) {
            log.info((Object)("Received entry updated event on the hzSystemMetadata map for pid: " + ((Identifier)event.getKey()).getValue()));
            if (this.isAuthoritativeReplicaValid((SystemMetadata)event.getValue())) {
                this.createReplicationTask((Identifier)event.getKey());
            } else {
                log.info((Object)("Authoritative replica is not valid, not queueing to replication for pid: " + ((Identifier)event.getKey()).getValue()));
            }
        }
    }

    private void createReplicationTask(Identifier identifier) {
        if (identifier == null || identifier.getValue() == null) {
            log.error((Object)"Replication Event Listener received event with null identifier");
            return;
        }
        List<ReplicationTask> existingTaskList = this.replicationTaskRepository.findByPid(identifier.getValue());
        if (existingTaskList.isEmpty()) {
            this.replicationTaskRepository.save(new ReplicationTask(identifier));
        } else if (existingTaskList.size() > 1) {
            log.error((Object)("Found more than one replication task object for pid:" + identifier.getValue() + ".  Deleting and creating new task."));
            this.replicationTaskRepository.delete(existingTaskList);
            this.replicationTaskRepository.save(new ReplicationTask(identifier));
        }
    }

    private boolean isAuthoritativeReplicaValid(SystemMetadata sysMeta) {
        if (sysMeta == null) {
            return false;
        }
        ReplicationStatus status = this.getAuthoritativeMNReplicaStatus(sysMeta);
        return ReplicationStatus.COMPLETED.equals((Object)status);
    }

    private ReplicationStatus getAuthoritativeMNReplicaStatus(SystemMetadata sysMeta) {
        NodeReference authNode = sysMeta.getAuthoritativeMemberNode();
        if (authNode == null) {
            log.debug((Object)("authoritative MN is null for pid: " + sysMeta.getIdentifier().getValue()));
            return null;
        }
        if (sysMeta.getReplicaList() != null) {
            for (Replica replica : sysMeta.getReplicaList()) {
                if (!authNode.equals((Object)replica.getReplicaMemberNode())) continue;
                return replica.getReplicationStatus();
            }
        } else {
            log.debug((Object)("replica list is null for pid: " + sysMeta.getIdentifier().getValue()));
        }
        return null;
    }

    public void entryRemoved(EntryEvent<Identifier, SystemMetadata> event) {
    }

    public void entryEvicted(EntryEvent<Identifier, SystemMetadata> event) {
    }
}

