/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.data.repository;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.dataone.cn.data.repository.ReplicationAttemptHistoryRepository;
import org.dataone.cn.data.repository.ReplicationTaskRepository;
import org.dataone.cn.model.repository.PostgresRepositoryConfiguration;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.ReplicationRepositoryFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableJpaRepositories(value={"org.dataone.cn.data.repository"})
@ComponentScan(value={"org.dataone.cn.data.repository"})
public class ReplicationPostgresRepositoryFactory
extends PostgresRepositoryConfiguration
implements ReplicationRepositoryFactory {
    private static final String urlProp = "datasource.replication.history.url";
    private static final String driverClassProp = "datasource.replication.history.driverClass";
    private static final String usernameProp = "datasource.replication.history.user";
    private static final String passwordProperty = "datasource.replication.history.password";
    private static final String initialPoolSizeProperty = "datasource.replication.history.initialSize";
    private static final String maxPoolSizeProperty = "datasource.replication.history.maxSize";
    private static final String url = Settings.getConfiguration().getString("datasource.replication.history.url");
    private static final String driverClass = Settings.getConfiguration().getString("datasource.replication.history.driverClass");
    private static final String username = Settings.getConfiguration().getString("datasource.replication.history.user");
    private static final String password = Settings.getConfiguration().getString("datasource.replication.history.password");
    private static final String initialPoolSize = Settings.getConfiguration().getString("datasource.replication.history.initialSize");
    private static final String maxPoolSize = Settings.getConfiguration().getString("datasource.replication.history.maxSize");
    private static BasicDataSource postgresDataSource;

    @Override
    public ReplicationAttemptHistoryRepository getReplicationTryHistoryRepository() {
        this.initContext();
        return (ReplicationAttemptHistoryRepository)this.context.getBean(ReplicationAttemptHistoryRepository.class);
    }

    @Override
    public ReplicationTaskRepository getReplicationTaskRepository() {
        this.initContext();
        return (ReplicationTaskRepository)this.context.getBean(ReplicationTaskRepository.class);
    }

    @Bean
    public DataSource dataSource() {
        if (postgresDataSource == null) {
            this.initDataSource();
        }
        return postgresDataSource;
    }

    private void initDataSource() {
        postgresDataSource = new BasicDataSource();
        postgresDataSource.setUrl(url);
        postgresDataSource.setDriverClassName(driverClass);
        postgresDataSource.setUsername(username);
        postgresDataSource.setPassword(password);
        postgresDataSource.setInitialSize(Integer.valueOf(initialPoolSize).intValue());
        postgresDataSource.setMaxActive(Integer.valueOf(maxPoolSize).intValue());
    }

    public String getPackagesToScan() {
        return "org.dataone.cn.data.repository";
    }
}

