/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import org.apache.log4j.Logger;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.cn.replication.ReplicationService;
import org.dataone.service.cn.replication.v1.MNCommunication;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;

public abstract class ReplicationCommunication {
    public static Logger log = Logger.getLogger(ReplicationCommunication.class);
    protected ReplicationService replicationService = ReplicationFactory.getReplicationService();

    public abstract boolean requestReplication(NodeReference var1, SystemMetadata var2) throws BaseException;

    public abstract Checksum getChecksumFromMN(Identifier var1, NodeReference var2, SystemMetadata var3) throws NotFound, BaseException;

    public static ReplicationCommunication getInstance(NodeReference targetNodeId) {
        Node targetNode = ReplicationFactory.getReplicationManager().getNode(targetNodeId);
        ReplicationCommunication impl = new MNCommunication();
        if (targetNode != null && targetNode.getServices() != null && targetNode.getServices().getServiceList() != null) {
            for (Service service : targetNode.getServices().getServiceList()) {
                if (!service.getName().equals("MNReplication") || !service.getVersion().equals("v2")) continue;
                impl = new org.dataone.service.cn.replication.v2.MNCommunication();
                break;
            }
        }
        return impl;
    }
}

