/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.batch.exceptions.ExecutionDisabledException;
import org.dataone.cn.batch.synchronization.HarvestSchedulingManager;
import org.dataone.cn.batch.synchronization.tasks.SyncObjectTask;
import org.quartz.SchedulerException;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

public class SyncObjectTaskManager
implements Runnable {
    static final Logger logger = Logger.getLogger(SyncObjectTaskManager.class);
    SyncObjectTask syncObjectTask;
    private SimpleAsyncTaskExecutor taskExecutor;
    Future syncObjectTaskManagerFuture = null;
    HarvestSchedulingManager harvestSchedulingManager;

    public void init() {
        this.syncObjectTaskManagerFuture = this.taskExecutor.submit((Runnable)this);
    }

    @Override
    public void run() {
        boolean shouldContinueRunning = true;
        do {
            if (ComponentActivationUtility.synchronizationIsActive()) {
                logger.info((Object)"SyncObjectTaskManager Start");
                FutureTask<String> futureTask = new FutureTask<String>(this.syncObjectTask);
                this.taskExecutor.execute(futureTask);
                try {
                    futureTask.get();
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)ex.getMessage());
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() instanceof ExecutionDisabledException) {
                        logger.warn((Object)"Excecution Disabled continue polling until shutdown");
                        shouldContinueRunning = true;
                    } else {
                        logger.error((Object)ex, (Throwable)ex);
                        shouldContinueRunning = false;
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex, (Throwable)ex);
                    shouldContinueRunning = false;
                }
                if (futureTask.isCancelled()) {
                    logger.warn((Object)"SyncObjectTask was cancelled");
                    shouldContinueRunning = false;
                    continue;
                }
                futureTask.cancel(true);
                continue;
            }
            logger.debug((Object)"SyncObjectTaskManager is disabled");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex1) {
                logger.warn((Object)ex1.getMessage());
                shouldContinueRunning = false;
            }
        } while (shouldContinueRunning);
        logger.info((Object)"SyncObjectTaskManager Complete");
        this.syncObjectTaskManagerFuture.cancel(true);
        ComponentActivationUtility.disableSynchronization();
        try {
            this.harvestSchedulingManager.halt();
        }
        catch (SchedulerException ex) {
            logger.error((Object)("Unable to halt Scheduled Tasks after failure: " + (Object)((Object)ex)), (Throwable)ex);
        }
    }

    public SyncObjectTask getSyncObjectTask() {
        return this.syncObjectTask;
    }

    public void setSyncObjectTask(SyncObjectTask syncObjectTask) {
        this.syncObjectTask = syncObjectTask;
    }

    public SimpleAsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(SimpleAsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public HarvestSchedulingManager getHarvestSchedulingManager() {
        return this.harvestSchedulingManager;
    }

    public void setHarvestSchedulingManager(HarvestSchedulingManager harvestSchedulingManager) {
        this.harvestSchedulingManager = harvestSchedulingManager;
    }
}

