/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.batch.exceptions.NodeCommUnavailable;
import org.dataone.cn.batch.service.v2.impl.NodeRegistrySyncServiceImpl;
import org.dataone.cn.batch.synchronization.NodeCommFactory;
import org.dataone.cn.batch.synchronization.type.NodeComm;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v2.Node;

public class NodeCommObjectListHarvestFactory
implements NodeCommFactory {
    static final Logger logger = Logger.getLogger(NodeCommObjectListHarvestFactory.class);
    private static ConcurrentMap<NodeReference, NodeComm> initializedMemberNodes = new ConcurrentHashMap<NodeReference, NodeComm>();
    private static NodeCommFactory nodeCommFactory = null;

    private NodeCommObjectListHarvestFactory() {
    }

    public static NodeCommFactory getInstance() {
        if (nodeCommFactory == null) {
            nodeCommFactory = new NodeCommObjectListHarvestFactory();
        }
        return nodeCommFactory;
    }

    @Override
    public NodeComm getNodeComm(NodeReference mnNodeId) throws ServiceFailure, NodeCommUnavailable {
        if (initializedMemberNodes.containsKey(mnNodeId)) {
            return (NodeComm)initializedMemberNodes.get(mnNodeId);
        }
        Object mNode = null;
        NodeRegistrySyncServiceImpl nodeRegistryService = new NodeRegistrySyncServiceImpl();
        Node node = null;
        boolean hasCore = false;
        boolean hasRead = false;
        boolean hasV2 = false;
        try {
            node = nodeRegistryService.getNode(mnNodeId);
            if (node.getServices() == null || node.getServices().getServiceList() == null) {
                throw new NodeCommUnavailable(mnNodeId + " does not have any services");
            }
            for (Service service : node.getServices().getServiceList()) {
                if (service.getVersion().equals("v2")) {
                    hasV2 = true;
                }
                if (service.getName().equals("MNCore")) {
                    hasCore = true;
                }
                if (service.getName().equals("MNRead")) {
                    hasRead = true;
                }
                if (!hasV2 || !hasCore || !hasRead) continue;
                break;
            }
        }
        catch (NotFound ex) {
            throw new NodeCommUnavailable(ex.getDescription());
        }
        if (!hasRead) {
            throw new NodeCommUnavailable(mnNodeId + " does not have MNRead Service");
        }
        if (!hasCore) {
            throw new NodeCommUnavailable(mnNodeId + " does not have MNCore Service");
        }
        mNode = hasV2 ? D1Client.getMN((String)node.getBaseURL()) : org.dataone.client.v1.itk.D1Client.getMN((String)node.getBaseURL());
        NodeComm nodeComm = new NodeComm(mNode, nodeRegistryService);
        initializedMemberNodes.putIfAbsent(mnNodeId, nodeComm);
        return nodeComm;
    }
}

