/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.jobs;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.batch.synchronization.tasks.ObjectListHarvestTask;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.NodeReference;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class MemberNodeHarvestJob
implements Job {
    static final Logger logger = Logger.getLogger(MemberNodeHarvestJob.class);

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        JobExecutionException jex = null;
        NodeReference nodeReference = new NodeReference();
        SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss zzz");
        String mnIdentifier = null;
        try {
            if (ComponentActivationUtility.synchronizationIsActive()) {
                mnIdentifier = jobContext.getMergedJobDataMap().getString("mnIdentifier");
                logger.info((Object)(mnIdentifier + " - ObjectListHarvestTask Start"));
                nodeReference.setValue(mnIdentifier);
                Integer pageSize = Settings.getConfiguration().getInt("Synchronization.mn_listobjects_page_size");
                ObjectListHarvestTask harvestTask = new ObjectListHarvestTask(nodeReference, pageSize);
                Date lastProcessingCompletedDate = harvestTask.call();
                if (lastProcessingCompletedDate == null) {
                    logger.info((Object)(mnIdentifier + " - ObjectListHarvestTask did not finish."));
                } else {
                    logger.info((Object)(mnIdentifier + " - ObjectListHarvestTask Completed at " + format.format(lastProcessingCompletedDate)));
                }
            } else {
                logger.warn((Object)(mnIdentifier + "-  ObjectListHarvestTask Disabled"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)(mnIdentifier + " - " + jobContext.getJobDetail().getKey().getName() + " died: " + ex.getMessage()), (Throwable)ex);
            jex = new JobExecutionException();
            jex.unscheduleFiringTrigger();
            jex.setStackTrace(ex.getStackTrace());
        }
        if (jex != null) {
            throw jex;
        }
    }
}

