/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.listener;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class SyncMetricLogJobTriggerListener
implements TriggerListener {
    private static final String name = "SyncMetricLogJobTriggerListener";
    private static BlockingQueue<Object> lockJobQueue = new ArrayBlockingQueue<Object>(1);
    private static final Object lock = new Object();
    private static Logger logger = Logger.getLogger(SyncMetricLogJobTriggerListener.class);

    public String getName() {
        return name;
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        this.releaseJob();
        logger.debug((Object)"triggersComplete ");
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        logger.debug((Object)"triggerFired");
    }

    public void triggerMisfired(Trigger trigger) {
        logger.debug((Object)"triggerMisFired");
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        logger.debug((Object)"vetoJobExecution");
        return !this.lockJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJob() {
        Object object = lock;
        synchronized (object) {
            logger.debug((Object)"releaseJob");
            lockJobQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockJob() {
        boolean locked;
        Object object = lock;
        synchronized (object) {
            locked = lockJobQueue.offer(lock);
        }
        logger.debug((Object)("lockJob is " + locked + " queue size is " + lockJobQueue.size()));
        return locked;
    }
}

