/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization;

import com.hazelcast.client.HazelcastClient;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.cn.batch.service.v2.NodeRegistrySyncService;
import org.dataone.cn.batch.service.v2.impl.NodeRegistrySyncServiceImpl;
import org.dataone.cn.batch.synchronization.jobs.MemberNodeHarvestJob;
import org.dataone.cn.batch.synchronization.jobs.SyncMetricLogJob;
import org.dataone.cn.batch.synchronization.listener.SyncMetricLogJobTriggerListener;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v2.NodeList;
import org.joda.time.DateTime;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HarvestSchedulingManager
implements ApplicationContextAware {
    static final Logger logger = Logger.getLogger(HarvestSchedulingManager.class);
    private static String groupName = "MemberNodeHarvesting";
    private static String metricLogGroupName = "MetricLogJobReporting";
    private static String metricLogTriggerName = "MetricLogJobTrigger";
    private static String metricLogJobName = "job-MetricLog";
    private Scheduler scheduler;
    ApplicationContext applicationContext;
    private NodeRegistrySyncService nodeRegistryService = new NodeRegistrySyncServiceImpl();
    private static String clientCertificateLocation = Settings.getConfiguration().getString("D1Client.certificate.directory") + File.separator + Settings.getConfiguration().getString("D1Client.certificate.filename");

    public void init() {
        try {
            HazelcastClient hazelcast = HazelcastClientFactory.getProcessingClient();
            logger.info((Object)"HarvestingScheduler starting up");
            CertificateManager.getInstance().setCertificateLocation(clientCertificateLocation);
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/org/dataone/configuration/synchQuartz.properties"));
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
            this.scheduler = schedulerFactory.getScheduler();
            this.manageHarvest();
            this.scheduleSyncMetricLogJob();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Loading properties file failedUnable to initialize jobs for scheduling: " + ex.getMessage());
        }
        catch (SchedulerException ex) {
            throw new IllegalStateException("Unable to initialize jobs for scheduling: " + ex.getMessage());
        }
    }

    public void halt() throws SchedulerException {
        this.scheduler.shutdown(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void manageHarvest() throws SchedulerException {
        if (!this.scheduler.isShutdown()) {
            try {
                if (this.scheduler.isStarted()) {
                    this.scheduler.standby();
                    while (!this.scheduler.getCurrentlyExecutingJobs().isEmpty()) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ex) {
                            logger.warn((Object)"Sleep interrupted. check again!");
                        }
                    }
                    GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)groupName);
                    Set jobsInGroup = this.scheduler.getJobKeys(groupMatcher);
                    for (JobKey jobKey : jobsInGroup) {
                        logger.info((Object)("deleting job " + jobKey.getGroup() + " " + jobKey.getName()));
                        this.scheduler.deleteJob(jobKey);
                    }
                }
                NodeList nodeList = this.nodeRegistryService.listNodes();
                logger.info((Object)("Node map has " + nodeList.sizeNodeList() + " entries"));
                for (Node node : nodeList.getNodeList()) {
                    this.addHarvest(node.getIdentifier(), node);
                }
                this.scheduler.start();
                if (!this.scheduler.isStarted()) return;
                logger.info((Object)"Scheduler is started");
                return;
            }
            catch (NotImplemented | ServiceFailure ex) {
                logger.error((Object)ex, ex);
                throw new IllegalStateException("Unable to initialize jobs for scheduling: " + ex.getMessage());
            }
        } else {
            logger.warn((Object)"Scheduler has been shutdown. Synchronization is not running");
        }
    }

    private String getCrontabEntry(Node node) {
        String seconds = node.getSynchronization().getSchedule().getSec();
        seconds = seconds.replace(" ", "");
        String minutes = node.getSynchronization().getSchedule().getMin();
        minutes = minutes.replace(" ", "");
        String hours = node.getSynchronization().getSchedule().getHour();
        hours = hours.replace(" ", "");
        String days = node.getSynchronization().getSchedule().getMday();
        days = days.replace(" ", "");
        String months = node.getSynchronization().getSchedule().getMon();
        months = months.replace(" ", "");
        String weekdays = node.getSynchronization().getSchedule().getWday();
        weekdays = weekdays.replace(" ", "");
        String years = node.getSynchronization().getSchedule().getYear();
        years = years.replace(" ", "");
        if (days.equalsIgnoreCase("?") && weekdays.equalsIgnoreCase("?")) {
            days = "*";
        } else if (!days.equalsIgnoreCase("?") && !weekdays.equalsIgnoreCase("?")) {
            if (days.equalsIgnoreCase("*") && weekdays.equalsIgnoreCase("*")) {
                weekdays = "?";
            } else if (days.equalsIgnoreCase("*")) {
                days = "?";
            } else {
                weekdays = "?";
            }
        }
        String crontab = seconds + " " + minutes + " " + hours + " " + days + " " + months + " " + weekdays + " " + years;
        return crontab;
    }

    private void addHarvest(NodeReference key, Node node) {
        if (node.getState().equals((Object)NodeState.UP) && node.isSynchronize() && node.getType().equals((Object)NodeType.MN)) {
            String crontabEntry = this.getCrontabEntry(node);
            JobKey jobKey = new JobKey("job-" + key.getValue(), groupName);
            try {
                if (!this.scheduler.checkExists(jobKey)) {
                    JobDetail job = JobBuilder.newJob(MemberNodeHarvestJob.class).withIdentity(jobKey).usingJobData("mnIdentifier", key.getValue()).build();
                    TriggerKey triggerKey = new TriggerKey("trigger-" + key.getValue(), groupName);
                    Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)crontabEntry)).build();
                    logger.info((Object)("scheduling  key " + key.getValue() + " with schedule " + crontabEntry));
                    this.scheduler.scheduleJob(job, trigger);
                } else {
                    logger.error((Object)("job-" + key.getValue() + " exists!"));
                }
            }
            catch (SchedulerException ex) {
                logger.error((Object)("Unable to initialize job key " + key.getValue() + " with schedule " + crontabEntry + "for scheduling: "), (Throwable)ex);
            }
        }
    }

    private void scheduleSyncMetricLogJob() {
        JobKey jobKey = new JobKey(metricLogJobName, metricLogGroupName);
        try {
            if (!this.scheduler.checkExists(jobKey)) {
                DateTime startTime = new DateTime().plusSeconds(30);
                JobDetail job = JobBuilder.newJob(SyncMetricLogJob.class).withIdentity(jobKey).build();
                TriggerKey triggerKey = new TriggerKey(metricLogTriggerName, metricLogGroupName);
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(startTime.toDate()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(60).repeatForever().withMisfireHandlingInstructionIgnoreMisfires()).forJob(job).build();
                logger.info((Object)("scheduling  key " + jobKey + " with schedule "));
                this.scheduler.scheduleJob(job, trigger);
                SyncMetricLogJobTriggerListener triggerListener = new SyncMetricLogJobTriggerListener();
                this.scheduler.getListenerManager().addTriggerListener((TriggerListener)triggerListener, (Matcher)KeyMatcher.keyEquals((Key)triggerKey));
            } else {
                logger.error((Object)(metricLogJobName + " exists!"));
            }
        }
        catch (SchedulerException ex) {
            logger.error((Object)("Unable to initialize job " + metricLogJobName + " for scheduling: "), (Throwable)ex);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

