/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.batch.synchronization.D1TypeUtils;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class SystemMetadataValidator {
    static final Logger logger = Logger.getLogger(SystemMetadataValidator.class);
    private SystemMetadata referenceSysMeta;

    public SystemMetadataValidator(SystemMetadata referenceSystemMetadata) throws InvalidSystemMetadata {
        if (referenceSystemMetadata == null) {
            throw new IllegalArgumentException("Reference SystemMetadata parameter cannot be null.");
        }
        SystemMetadataValidator.schemaValidateSystemMetadata(referenceSystemMetadata);
        this.referenceSysMeta = referenceSystemMetadata;
    }

    public SystemMetadata getReferenceSystemMetadata() {
        return this.referenceSysMeta;
    }

    public static void schemaValidateSystemMetadata(SystemMetadata sysmeta) throws InvalidSystemMetadata {
        logger.info((Object)"Entering schemaValidateSysMeta method...");
        try {
            TypeMarshaller.validateAgainstSchema((Object)sysmeta);
        }
        catch (MarshallingException e) {
            String pid = "null";
            if (sysmeta != null && !D1TypeUtils.valueEquals(sysmeta.getIdentifier(), null)) {
                pid = sysmeta.getIdentifier().getValue();
            }
            String errorMessage = "The SystemMetadata for pid: " + pid + " is not schema valid";
            InvalidSystemMetadata be = new InvalidSystemMetadata("000", errorMessage);
            be.initCause((Throwable)e);
            logger.error((Object)errorMessage, (Throwable)be);
            throw be;
        }
    }

    public static void validateCNRequiredNonNullFields(SystemMetadata sysmeta) throws InvalidSystemMetadata {
        LinkedList<String> illegalNullFields = new LinkedList<String>();
        if (sysmeta.getIdentifier() == null) {
            illegalNullFields.add("identifier");
        }
        if (sysmeta.getOriginMemberNode() == null) {
            illegalNullFields.add("originMemberNode");
        }
        if (sysmeta.getAuthoritativeMemberNode() == null) {
            illegalNullFields.add("authoritativeMemberNode");
        }
        if (sysmeta.getDateUploaded() == null) {
            illegalNullFields.add("dateUploaded");
        }
        if (sysmeta.getDateSysMetadataModified() == null) {
            illegalNullFields.add("dateSysMetadataModified");
        }
        if (sysmeta.getSubmitter() == null) {
            illegalNullFields.add("submitter");
        }
        if (illegalNullFields.size() > 0) {
            throw new InvalidSystemMetadata("-1", "The following properties cannot be null: " + StringUtils.join(illegalNullFields, (String)", "));
        }
    }

    public void validateEssentialProperties(SystemMetadata newSysMeta, Object authoritativeNodeReadImpl) throws IdentifierNotUnique, ServiceFailure, InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, NotFound {
        Checksum newChecksum;
        if (!this.referenceSysMeta.getIdentifier().equals((Object)newSysMeta.getIdentifier())) {
            throw new IdentifierNotUnique("-1", "Identifier does not match the reference SystemMetadata's!");
        }
        if (this.referenceSysMeta.getChecksum() == null) {
            String message = "Reference systemMetadata's checksum is null!";
            logger.error((Object)message);
            throw new ServiceFailure("00-SystemMetadataValidator", message);
        }
        String cnCsAlgorithm = this.referenceSysMeta.getChecksum().getAlgorithm();
        if (!cnCsAlgorithm.equalsIgnoreCase((newChecksum = newSysMeta.getChecksum()).getAlgorithm())) {
            logger.info((Object)"Try to retrieve a checksum from membernode that matches the algorithm of existing systemMetadata");
            if (authoritativeNodeReadImpl instanceof MNRead) {
                newChecksum = ((MNRead)authoritativeNodeReadImpl).getChecksum(null, newSysMeta.getIdentifier(), cnCsAlgorithm);
            } else if (authoritativeNodeReadImpl instanceof org.dataone.service.mn.tier1.v1.MNRead) {
                newChecksum = ((org.dataone.service.mn.tier1.v1.MNRead)authoritativeNodeReadImpl).getChecksum(null, newSysMeta.getIdentifier(), cnCsAlgorithm);
            } else {
                throw new NotImplemented("0000", "Do not support authoritativeNodeReadImpl Object type (" + authoritativeNodeReadImpl.getClass().getCanonicalName() + "), so couldnot compare checksums (needed the MN to recalculate).");
            }
        }
        if (!newChecksum.getValue().contentEquals(this.referenceSysMeta.getChecksum().getValue())) {
            logger.info((Object)"Submitted checksum doesn't match the existing one!");
            throw new IdentifierNotUnique("-1", "Checksum does not match existing object with same pid.");
        }
        logger.info((Object)"The submitted checksum matches existing one");
    }

    public boolean hasValidUpdates(SystemMetadata proposedSystemMetadata) throws InvalidRequest, ServiceFailure {
        int changes = this.validateRestrictedFields(proposedSystemMetadata, this.referenceSysMeta);
        if (changes > 0) {
            return true;
        }
        return this.findChangesInUnrestrictedFields(proposedSystemMetadata, this.referenceSysMeta);
    }

    private int validateRestrictedFields(SystemMetadata newSysMeta, SystemMetadata cnSysMeta) throws InvalidRequest {
        int changes = 0;
        LinkedList<String> illegalChangeFields = new LinkedList<String>();
        if (!ObjectUtils.equals((Object)cnSysMeta.getSize(), (Object)newSysMeta.getSize())) {
            illegalChangeFields.add("size");
        }
        if (!D1TypeUtils.equals(cnSysMeta.getSubmitter(), newSysMeta.getSubmitter())) {
            illegalChangeFields.add("submitter");
        }
        if (!D1TypeUtils.equals(cnSysMeta.getObsoletes(), newSysMeta.getObsoletes())) {
            if (cnSysMeta.getObsoletes() == null) {
                ++changes;
            } else {
                illegalChangeFields.add("obsoletes");
            }
        }
        if (!D1TypeUtils.equals(cnSysMeta.getObsoletedBy(), newSysMeta.getObsoletedBy())) {
            if (cnSysMeta.getObsoletedBy() == null) {
                ++changes;
            } else {
                illegalChangeFields.add("obsoletedBy");
            }
        }
        if (!ObjectUtils.equals((Object)cnSysMeta.getArchived(), (Object)newSysMeta.getArchived())) {
            if (((Boolean)ObjectUtils.defaultIfNull((Object)cnSysMeta.getArchived(), (Object)Boolean.FALSE)).booleanValue()) {
                logger.debug((Object)String.format("starting archived value: '%s', new value '%s'", cnSysMeta.getArchived(), newSysMeta.getArchived()));
                illegalChangeFields.add("archived");
            } else {
                ++changes;
            }
        }
        if (cnSysMeta.getDateUploaded() == null && newSysMeta.getDateUploaded() != null || cnSysMeta.getDateUploaded() != null && newSysMeta.getDateUploaded() == null || cnSysMeta.getDateUploaded() != null && newSysMeta.getDateUploaded() != null && cnSysMeta.getDateUploaded().getTime() != newSysMeta.getDateUploaded().getTime()) {
            illegalChangeFields.add("dateUploaded");
        }
        if (!ObjectUtils.equals((Object)cnSysMeta.getOriginMemberNode(), (Object)newSysMeta.getOriginMemberNode())) {
            illegalChangeFields.add("originMemberNode");
        }
        if (!ObjectUtils.equals((Object)cnSysMeta.getAuthoritativeMemberNode(), (Object)newSysMeta.getAuthoritativeMemberNode())) {
            illegalChangeFields.add("authoritativeMemberNode");
        }
        if (!D1TypeUtils.equals(cnSysMeta.getSeriesId(), newSysMeta.getSeriesId())) {
            if (cnSysMeta.getSeriesId() == null) {
                ++changes;
            } else {
                illegalChangeFields.add("seriesId");
            }
        }
        if (illegalChangeFields.size() > 0) {
            throw new InvalidRequest("-1", "Illegal changes attempted to the fields: " + StringUtils.join(illegalChangeFields, (String)", "));
        }
        return changes;
    }

    private boolean findChangesInUnrestrictedFields(SystemMetadata newSysMeta, SystemMetadata cnSysMeta) throws ServiceFailure {
        if (!D1TypeUtils.equals(cnSysMeta.getRightsHolder(), newSysMeta.getRightsHolder())) {
            return true;
        }
        if (!D1TypeUtils.equals(cnSysMeta.getAuthoritativeMemberNode(), newSysMeta.getAuthoritativeMemberNode())) {
            return true;
        }
        if (newSysMeta.getAccessPolicy() == null ^ cnSysMeta.getAccessPolicy() == null) {
            return true;
        }
        if (newSysMeta.getReplicationPolicy() == null ^ cnSysMeta.getReplicationPolicy() == null) {
            return true;
        }
        if (newSysMeta.getAccessPolicy() != null && newSysMeta.getAccessPolicy().sizeAllowList() != cnSysMeta.getAccessPolicy().sizeAllowList()) {
            return true;
        }
        if (newSysMeta.getReplicationPolicy() != null) {
            if (newSysMeta.getReplicationPolicy().getNumberReplicas() != cnSysMeta.getReplicationPolicy().getNumberReplicas()) {
                return true;
            }
            if (newSysMeta.getReplicationPolicy().sizePreferredMemberNodeList() != cnSysMeta.getReplicationPolicy().sizePreferredMemberNodeList()) {
                return true;
            }
            if (newSysMeta.getReplicationPolicy().sizeBlockedMemberNodeList() != cnSysMeta.getReplicationPolicy().sizeBlockedMemberNodeList()) {
                return true;
            }
        }
        StringBuffer message = new StringBuffer();
        try {
            if (!D1TypeUtils.serializedFormEquals(newSysMeta.getAccessPolicy(), cnSysMeta.getAccessPolicy())) {
                return true;
            }
        }
        catch (IOException | MarshallingException e1) {
            message.append("Problems serializing one of the AccessPolicies: " + e1.getMessage());
        }
        try {
            if (!D1TypeUtils.serializedFormEquals(newSysMeta.getReplicationPolicy(), cnSysMeta.getReplicationPolicy())) {
                return true;
            }
        }
        catch (IOException | MarshallingException e1) {
            message.append(" Could not compare serialized forms of the ReplicationPolicies");
        }
        if (message.length() > 0) {
            throw new ServiceFailure("-1", "Problems comparing SystemMetadata: " + message.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean customSerializationCompareComplexFields(SystemMetadata newSysMeta) throws ServiceFailure {
        ByteArrayOutputStream cnRPos;
        ByteArrayOutputStream newRPos;
        boolean exceptionEncountered;
        block14: {
            boolean bl;
            int progress;
            ByteArrayOutputStream cnAPos;
            ByteArrayOutputStream newAPos;
            block13: {
                boolean bl2;
                newAPos = null;
                cnAPos = null;
                progress = 0;
                exceptionEncountered = false;
                try {
                    if (newSysMeta.getAccessPolicy() == null) break block13;
                    newAPos = new ByteArrayOutputStream();
                    cnAPos = new ByteArrayOutputStream();
                    TypeMarshaller.marshalTypeToOutputStream((Object)newSysMeta.getAccessPolicy(), (OutputStream)newAPos);
                    ++progress;
                    TypeMarshaller.marshalTypeToOutputStream((Object)this.referenceSysMeta.getAccessPolicy(), (OutputStream)cnAPos);
                    if (Arrays.equals(newAPos.toByteArray(), cnAPos.toByteArray())) break block13;
                    bl2 = true;
                }
                catch (IOException | MarshallingException e) {
                    try {
                        if (progress == 0) {
                            logger.error((Object)"Couldn't reserialize the AccessPolicy of the new systemMetadata!", e);
                        } else {
                            logger.error((Object)"Couldn't reserialize the AccessPolicy of the reference systemMetadata!", e);
                        }
                        exceptionEncountered = true;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(newAPos);
                        IOUtils.closeQuietly(cnAPos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)newAPos);
                    IOUtils.closeQuietly((OutputStream)cnAPos);
                }
                IOUtils.closeQuietly((OutputStream)newAPos);
                IOUtils.closeQuietly((OutputStream)cnAPos);
                return bl2;
            }
            IOUtils.closeQuietly(newAPos);
            IOUtils.closeQuietly(cnAPos);
            newRPos = null;
            cnRPos = null;
            progress = 0;
            try {
                if (newSysMeta.getReplicationPolicy() == null) break block14;
                newRPos = new ByteArrayOutputStream();
                cnRPos = new ByteArrayOutputStream();
                TypeMarshaller.marshalTypeToOutputStream((Object)this.referenceSysMeta.getAccessPolicy(), (OutputStream)cnRPos);
                ++progress;
                TypeMarshaller.marshalTypeToOutputStream((Object)newSysMeta.getAccessPolicy(), (OutputStream)newRPos);
                if (Arrays.equals(newRPos.toByteArray(), cnRPos.toByteArray())) break block14;
                bl = true;
            }
            catch (IOException | MarshallingException e) {
                try {
                    if (progress == 0) {
                        logger.error((Object)"Couldn't reserialize the ReplicationPolicy of the reference systemMetadata!", e);
                    } else {
                        logger.error((Object)"Couldn't reserialize the ReplicationPolicy of the new systemMetadata!", e);
                    }
                    exceptionEncountered = true;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(newRPos);
                    IOUtils.closeQuietly(cnRPos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)newRPos);
                IOUtils.closeQuietly((OutputStream)cnRPos);
            }
            IOUtils.closeQuietly((OutputStream)newRPos);
            IOUtils.closeQuietly((OutputStream)cnRPos);
            return bl;
        }
        IOUtils.closeQuietly(newRPos);
        IOUtils.closeQuietly(cnRPos);
        if (exceptionEncountered) {
            throw new ServiceFailure("-1", "Could not validate changes.  Problem reserializing one or more AccessPolicies or ReplicationPolicies.");
        }
        return false;
    }
}

